/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.machine;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.BaseEncoding;
import com.google.common.io.Files;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import lombok.Generated;
import me.ahoo.cosid.CosIdException;
import me.ahoo.cosid.machine.InstanceId;
import me.ahoo.cosid.machine.MachineState;
import me.ahoo.cosid.machine.MachineStateStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalMachineStateStorage
implements MachineStateStorage {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalMachineStateStorage.class);
    public static final String DEFAULT_STATE_LOCATION_PATH = Paths.get(System.getProperty("user.home"), ".cosid-machine-state").toString();
    public final String stateLocation;

    public LocalMachineStateStorage(String stateLocation) {
        this.stateLocation = stateLocation;
    }

    public LocalMachineStateStorage() {
        this(DEFAULT_STATE_LOCATION_PATH);
    }

    @Override
    @Nonnull
    public MachineState get(String namespace, InstanceId instanceId) {
        String stateString;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)namespace) ? 1 : 0) != 0, (Object)"namespace can not be empty!");
        Preconditions.checkNotNull((Object)instanceId, (Object)"instanceId can not be null!");
        File stateFile = this.getStateFile(namespace, instanceId);
        if (log.isDebugEnabled()) {
            log.debug("Get from stateLocation : [{}].", (Object)stateFile.getAbsolutePath());
        }
        if (!stateFile.exists()) {
            if (log.isInfoEnabled()) {
                log.info("Get from stateLocation : [{}] not found.", (Object)stateFile.getAbsolutePath());
            }
            return MachineState.NOT_FOUND;
        }
        try {
            stateString = Files.asCharSource((File)stateFile, (Charset)Charsets.UTF_8).readFirstLine();
        }
        catch (IOException e) {
            throw new CosIdException(e);
        }
        if (Strings.isNullOrEmpty((String)stateString)) {
            if (log.isWarnEnabled()) {
                log.warn("Get from stateLocation : [{}] state data is empty.", (Object)stateFile.getAbsolutePath());
            }
            return MachineState.NOT_FOUND;
        }
        if (log.isDebugEnabled()) {
            log.debug("Get state data : [{}].", (Object)stateString);
        }
        return MachineState.of(stateString);
    }

    private File getStateFile(String namespace, InstanceId instanceId) {
        File stateDirectory = new File(this.stateLocation);
        if (!stateDirectory.exists()) {
            boolean bl = stateDirectory.mkdirs();
        }
        String fileName = namespace + "__" + instanceId.getInstanceId();
        String encodedName = this.encode(fileName);
        String statePath = Paths.get(this.stateLocation, encodedName).toString();
        return new File(statePath);
    }

    private String encode(String text) {
        return BaseEncoding.base64().encode(text.getBytes(Charsets.UTF_8));
    }

    @Override
    public void set(String namespace, int machineId, InstanceId instanceId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)namespace) ? 1 : 0) != 0, (Object)"namespace can not be empty!");
        Preconditions.checkArgument((machineId >= 0 ? 1 : 0) != 0, (String)"machineId:[%s] must be greater than or equal to 0!", (int)machineId);
        Preconditions.checkNotNull((Object)instanceId, (Object)"instanceId can not be null!");
        File stateFile = this.getStateFile(namespace, instanceId);
        if (log.isDebugEnabled()) {
            log.debug("Set machineId:[{}] to stateLocation : [{}].", (Object)machineId, (Object)stateFile.getAbsolutePath());
        }
        String stateString = MachineState.of(machineId, System.currentTimeMillis()).toStateString();
        if (!stateFile.exists()) {
            try {
                boolean bl = stateFile.createNewFile();
            }
            catch (IOException e) {
                throw new CosIdException(e);
            }
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(stateFile, false);){
            fileOutputStream.write(stateString.getBytes(Charsets.UTF_8));
            fileOutputStream.flush();
        }
        catch (IOException e) {
            throw new CosIdException(e.getMessage(), e);
        }
    }

    @Override
    public void remove(String namespace, InstanceId instanceId) {
        boolean isDeleted;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)namespace) ? 1 : 0) != 0, (Object)"namespace can not be empty!");
        Preconditions.checkNotNull((Object)instanceId, (Object)"instanceId can not be null!");
        File stateFile = this.getStateFile(namespace, instanceId);
        if (log.isInfoEnabled()) {
            log.info("Remove stateLocation : [{}].", (Object)stateFile.getAbsolutePath());
        }
        if (stateFile.exists() && !(isDeleted = stateFile.delete())) {
            log.warn("Remove and delete instance :[{}] stateFile in namespace[{}] not successful! FilePath:[{}]", new Object[]{instanceId, namespace, stateFile.getAbsolutePath()});
        }
    }

    @Override
    public void clear(String namespace) {
        File[] stateFiles;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)namespace) ? 1 : 0) != 0, (Object)"namespace can not be empty!");
        if (log.isInfoEnabled()) {
            log.info("Clear namespace : [{}].", (Object)namespace);
        }
        if ((stateFiles = this.getStateFilesOf(namespace)) == null) {
            return;
        }
        for (File stateFile : stateFiles) {
            if (log.isInfoEnabled()) {
                log.info("Clear stateLocation : [{}].", (Object)stateFile.getAbsolutePath());
            }
            boolean bl = stateFile.delete();
        }
    }

    private File[] getStateFilesOf(String namespace) {
        File stateDirectory = new File(this.stateLocation);
        if (!stateDirectory.exists()) {
            return new File[0];
        }
        String encodedNamespace = this.encode(namespace);
        return stateDirectory.listFiles((dir, name) -> name.startsWith(encodedNamespace));
    }

    @Override
    public int size(String namespace) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)namespace) ? 1 : 0) != 0, (Object)"namespace can not be empty!");
        return this.getStateFilesOf(namespace).length;
    }

    @Override
    public boolean exists(String namespace, InstanceId instanceId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)namespace) ? 1 : 0) != 0, (Object)"namespace can not be empty!");
        Preconditions.checkNotNull((Object)instanceId, (Object)"instanceId can not be null!");
        File stateFile = this.getStateFile(namespace, instanceId);
        return stateFile.exists();
    }
}

