/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.cosid;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.List;
import me.ahoo.cosid.converter.RadixIdConverter;
import me.ahoo.cosid.cosid.CosIdIdStateParser;
import me.ahoo.cosid.cosid.CosIdState;

public class FriendlyIdStateParser
implements CosIdIdStateParser {
    public static final int DECIMAL_RADIX = 10;
    private final ZoneId zoneId;
    private final boolean padStart;
    public static final DateTimeFormatter DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4).appendValue(ChronoField.MONTH_OF_YEAR, 2).appendValue(ChronoField.DAY_OF_MONTH, 2).appendValue(ChronoField.HOUR_OF_DAY, 2).appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendValue(ChronoField.MILLI_OF_SECOND, 3).toFormatter();
    private final int machineCharSize;
    private final int sequenceCharSize;

    public FriendlyIdStateParser(ZoneId zoneId, boolean padStart, int machineBit, int sequenceBit) {
        this.zoneId = zoneId;
        this.padStart = padStart;
        this.machineCharSize = RadixIdConverter.maxCharSize(10, machineBit);
        this.sequenceCharSize = RadixIdConverter.maxCharSize(10, sequenceBit);
    }

    @Override
    public CosIdState asState(String id) {
        List segments = Splitter.on((String)"-").trimResults().omitEmptyStrings().splitToList((CharSequence)id);
        if (segments.size() != 3) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)"id :[%s] Illegal.", (Object[])new Object[]{id}));
        }
        String timestampStr = (String)segments.get(0);
        long timestamp = LocalDateTime.parse(timestampStr, DATE_TIME_FORMATTER).atZone(this.zoneId).toInstant().toEpochMilli();
        int machineId = Integer.parseInt((String)segments.get(1));
        int sequence = Integer.parseInt((String)segments.get(2));
        return new CosIdState(timestamp, machineId, sequence);
    }

    public static String intAsString(boolean padStart, int value, int charSize) {
        if (padStart) {
            return Strings.padStart((String)String.valueOf(value), (int)charSize, (char)'0');
        }
        return String.valueOf(value);
    }

    @Override
    public String asString(long lastTimestamp, int machineId, int sequence) {
        LocalDateTime timestamp = this.getTimestamp(lastTimestamp);
        return timestamp.format(DATE_TIME_FORMATTER) + "-" + FriendlyIdStateParser.intAsString(this.padStart, machineId, this.machineCharSize) + "-" + FriendlyIdStateParser.intAsString(this.padStart, sequence, this.sequenceCharSize);
    }

    private LocalDateTime getTimestamp(long lastTimestamp) {
        return Instant.ofEpochMilli(lastTimestamp).atZone(this.zoneId).toLocalDateTime();
    }
}

