/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.cosid;

import com.google.common.base.MoreObjects;
import java.util.Objects;

public final class CosIdState
implements Comparable<CosIdState> {
    private final long timestamp;
    private final int machineId;
    private final int sequence;

    public CosIdState(long timestamp, int machineId, int sequence) {
        this.timestamp = timestamp;
        this.machineId = machineId;
        this.sequence = sequence;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getMachineId() {
        return this.machineId;
    }

    public int getSequence() {
        return this.sequence;
    }

    @Override
    public int compareTo(CosIdState o) {
        int timestampCompared = Long.compare(this.timestamp, o.timestamp);
        if (timestampCompared != 0) {
            return timestampCompared;
        }
        return Integer.compare(this.sequence, o.sequence);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CosIdState)) {
            return false;
        }
        CosIdState that = (CosIdState)o;
        return this.getTimestamp() == that.getTimestamp() && this.getMachineId() == that.getMachineId() && this.getSequence() == that.getSequence();
    }

    public int hashCode() {
        return Objects.hash(this.getTimestamp(), this.getMachineId(), this.getSequence());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("timestamp", this.timestamp).add("machineId", this.machineId).add("sequence", this.sequence).toString();
    }
}

