/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.converter;

import jakarta.annotation.Nonnull;
import me.ahoo.cosid.IdConverter;
import me.ahoo.cosid.snowflake.MillisecondSnowflakeIdStateParser;
import me.ahoo.cosid.snowflake.SnowflakeIdStateParser;
import me.ahoo.cosid.stat.Stat;
import me.ahoo.cosid.stat.converter.SnowflakeFriendlyIdConverterStat;

public class SnowflakeFriendlyIdConverter
implements IdConverter {
    public static final IdConverter INSTANCE = new SnowflakeFriendlyIdConverter(MillisecondSnowflakeIdStateParser.INSTANCE);
    private final SnowflakeIdStateParser snowflakeIdStateParser;

    public SnowflakeFriendlyIdConverter(SnowflakeIdStateParser snowflakeIdStateParser) {
        this.snowflakeIdStateParser = snowflakeIdStateParser;
    }

    public SnowflakeIdStateParser getParser() {
        return this.snowflakeIdStateParser;
    }

    @Override
    @Nonnull
    public String asString(long id) {
        return this.snowflakeIdStateParser.parse(id).getFriendlyId();
    }

    @Override
    public long asLong(@Nonnull String idString) {
        return this.snowflakeIdStateParser.parse(idString).getId();
    }

    @Override
    public Stat stat() {
        return new SnowflakeFriendlyIdConverterStat(this.getClass().getSimpleName(), this.snowflakeIdStateParser.isPadStart(), this.snowflakeIdStateParser.getMachineCharSize(), this.snowflakeIdStateParser.getSequenceCharSize());
    }
}

