/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.segment.concurrent;

import com.google.common.base.Strings;
import java.time.Duration;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import lombok.Generated;
import me.ahoo.cosid.segment.concurrent.AffinityJob;
import me.ahoo.cosid.segment.concurrent.PrefetchWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPrefetchWorker
extends Thread
implements PrefetchWorker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultPrefetchWorker.class);
    private static final AtomicInteger THREAD_COUNTER = new AtomicInteger();
    private volatile boolean shutdown = false;
    private final Duration prefetchPeriod;
    private final CopyOnWriteArraySet<AffinityJob> affinityJobs = new CopyOnWriteArraySet();

    public DefaultPrefetchWorker(Duration prefetchPeriod) {
        super(Strings.lenientFormat((String)("DefaultPrefetchWorker-" + THREAD_COUNTER.incrementAndGet()), (Object[])new Object[0]));
        this.prefetchPeriod = prefetchPeriod;
    }

    @Override
    public void shutdown() {
        if (log.isInfoEnabled()) {
            log.info("Shutdown!");
        }
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
    }

    @Override
    public void submit(AffinityJob affinityJob) {
        if (log.isInfoEnabled()) {
            log.info("Submit [{}] jobSize:[{}].", (Object)affinityJob.getJobId(), (Object)this.affinityJobs.size());
        }
        if (this.shutdown) {
            throw new IllegalArgumentException("PrefetchWorker is shutdown.");
        }
        this.affinityJobs.add(affinityJob);
    }

    @Override
    public void cancel(AffinityJob affinityJob) {
        if (log.isInfoEnabled()) {
            log.info("Cancel [{}] jobSize:[{}].", (Object)affinityJob.getJobId(), (Object)this.affinityJobs.size());
        }
        this.affinityJobs.remove(affinityJob);
    }

    @Override
    public void wakeup(AffinityJob affinityJob) {
        if (log.isDebugEnabled()) {
            log.debug("Wakeup [{}] - state:[{}].", (Object)affinityJob.getJobId(), (Object)this.getState());
        }
        if (this.shutdown) {
            if (log.isWarnEnabled()) {
                log.warn("Wakeup [{}] - PrefetchWorker is shutdown,Can't be awakened!", (Object)affinityJob.getJobId());
            }
            return;
        }
        if (Thread.State.RUNNABLE.equals((Object)this.getState())) {
            if (log.isDebugEnabled()) {
                log.debug("Wakeup [{}] - PrefetchWorker is running ,Don't need to be awakened.", (Object)affinityJob.getJobId());
            }
            return;
        }
        LockSupport.unpark(this);
    }

    @Override
    public void run() {
        while (!this.shutdown) {
            try {
                this.affinityJobs.forEach(affinityJob -> {
                    block2: {
                        try {
                            affinityJob.run();
                        }
                        catch (Throwable throwable) {
                            if (!log.isErrorEnabled()) break block2;
                            log.error(throwable.getMessage(), throwable);
                        }
                    }
                });
                LockSupport.parkNanos(this, this.prefetchPeriod.toNanos());
            }
            catch (Throwable throwable) {
                if (!log.isErrorEnabled()) continue;
                log.error(throwable.getMessage(), throwable);
            }
        }
    }
}

