/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.machine;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import lombok.Generated;
import me.ahoo.cosid.machine.HostAddressSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocalHostAddressSupplier
implements HostAddressSupplier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalHostAddressSupplier.class);
    public static final LocalHostAddressSupplier INSTANCE = new LocalHostAddressSupplier();

    @Override
    public String getHostAddress() {
        String hostAddress = InetAddress.getLocalHost().getHostAddress();
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface eachNetworkInterface = networkInterfaces.nextElement();
                if (!eachNetworkInterface.isUp() || eachNetworkInterface.isLoopback()) continue;
                Enumeration<InetAddress> inetAddresses = eachNetworkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (!(inetAddress instanceof Inet4Address) || inetAddress.isLoopbackAddress() || inetAddress.isAnyLocalAddress()) continue;
                    hostAddress = inetAddress.getHostAddress();
                }
            }
        }
        catch (Exception ex) {
            log.error("Cannot get first non-loopback address", (Throwable)ex);
        }
        return hostAddress;
    }
}

