/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.machine;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import lombok.Generated;
import me.ahoo.cosid.machine.ClockBackwardsSynchronizer;
import me.ahoo.cosid.machine.InstanceId;
import me.ahoo.cosid.machine.MachineIdDistributor;
import me.ahoo.cosid.machine.MachineIdLostException;
import me.ahoo.cosid.machine.MachineIdOverflowException;
import me.ahoo.cosid.machine.MachineState;
import me.ahoo.cosid.machine.MachineStateStorage;
import me.ahoo.cosid.machine.NotFoundMachineStateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMachineIdDistributor
implements MachineIdDistributor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractMachineIdDistributor.class);
    public static final int NOT_FOUND_LAST_STAMP = -1;
    private final MachineStateStorage machineStateStorage;
    private final ClockBackwardsSynchronizer clockBackwardsSynchronizer;

    public AbstractMachineIdDistributor(MachineStateStorage machineStateStorage, ClockBackwardsSynchronizer clockBackwardsSynchronizer) {
        this.machineStateStorage = machineStateStorage;
        this.clockBackwardsSynchronizer = clockBackwardsSynchronizer;
    }

    @Override
    @Nonnull
    public MachineState distribute(String namespace, int machineBit, InstanceId instanceId, Duration safeGuardDuration) throws MachineIdOverflowException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)namespace) ? 1 : 0) != 0, (Object)"namespace can not be empty!");
        Preconditions.checkArgument((machineBit > 0 ? 1 : 0) != 0, (String)"machineBit:[%s] must be greater than 0!", (int)machineBit);
        Preconditions.checkNotNull((Object)instanceId, (Object)"instanceId can not be null!");
        MachineState localState = this.machineStateStorage.get(namespace, instanceId);
        if (!MachineState.NOT_FOUND.equals(localState)) {
            this.clockBackwardsSynchronizer.syncUninterruptibly(localState.getLastTimeStamp());
            return localState;
        }
        localState = this.distributeRemote(namespace, machineBit, instanceId, safeGuardDuration);
        if (ClockBackwardsSynchronizer.getBackwardsTimeStamp(localState.getLastTimeStamp()) > 0L) {
            this.clockBackwardsSynchronizer.syncUninterruptibly(localState.getLastTimeStamp());
            localState = MachineState.of(localState.getMachineId(), System.currentTimeMillis());
        }
        this.machineStateStorage.set(namespace, localState.getMachineId(), instanceId);
        return localState;
    }

    protected abstract MachineState distributeRemote(String var1, int var2, InstanceId var3, Duration var4);

    @Override
    public void revert(String namespace, InstanceId instanceId) {
        MachineState lastLocalState = this.resetStorage(namespace, instanceId);
        this.revertRemote(namespace, instanceId, lastLocalState);
    }

    protected abstract void revertRemote(String var1, InstanceId var2, MachineState var3);

    @Override
    public void guard(String namespace, InstanceId instanceId, Duration safeGuardDuration) throws NotFoundMachineStateException, MachineIdLostException {
        MachineState lastLocalState = this.resetStorage(namespace, instanceId);
        this.guardRemote(namespace, instanceId, lastLocalState, safeGuardDuration);
    }

    private MachineState resetStorage(String namespace, InstanceId instanceId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)namespace) ? 1 : 0) != 0, (Object)"namespace can not be empty!");
        Preconditions.checkNotNull((Object)instanceId, (Object)"instanceId can not be null!");
        MachineState lastLocalState = this.machineStateStorage.get(namespace, instanceId);
        if (MachineState.NOT_FOUND.equals(lastLocalState)) {
            throw new NotFoundMachineStateException(namespace, instanceId);
        }
        if (ClockBackwardsSynchronizer.getBackwardsTimeStamp(lastLocalState.getLastTimeStamp()) < 0L) {
            lastLocalState = MachineState.of(lastLocalState.getMachineId(), System.currentTimeMillis());
            this.machineStateStorage.set(namespace, lastLocalState.getMachineId(), instanceId);
        }
        return lastLocalState;
    }

    protected abstract void guardRemote(String var1, InstanceId var2, MachineState var3, Duration var4);
}

