/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.converter;

import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import me.ahoo.cosid.Decorator;
import me.ahoo.cosid.IdConverter;
import me.ahoo.cosid.segment.grouped.GroupedAccessor;
import me.ahoo.cosid.stat.Stat;
import me.ahoo.cosid.stat.converter.GroupedPrefixConverterStat;

public class GroupedPrefixIdConverter
implements IdConverter,
Decorator<IdConverter> {
    public static final String DEFAULT_DELIMITER = "-";
    private final String delimiter;
    private final IdConverter actual;

    public GroupedPrefixIdConverter(String delimiter, IdConverter actual) {
        Preconditions.checkNotNull((Object)delimiter, (Object)"prefix can not be null!");
        this.delimiter = delimiter;
        this.actual = actual;
    }

    @Override
    @Nonnull
    public IdConverter getActual() {
        return this.actual;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    @Override
    @Nonnull
    public String asString(long id) {
        String idStr = this.actual.asString(id);
        String groupKey = GroupedAccessor.requiredGet().getKey();
        if (this.delimiter.isEmpty()) {
            return groupKey + idStr;
        }
        return groupKey + this.delimiter + idStr;
    }

    @Override
    public long asLong(@Nonnull String idString) {
        throw new UnsupportedOperationException("GroupedPrefixIdConverter does not support converting String to Long!");
    }

    @Override
    public Stat stat() {
        return new GroupedPrefixConverterStat(this.getClass().getSimpleName(), this.delimiter, this.actual.stat());
    }
}

