/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.circulinear.buffer;

import math.geom2d.Angle2D;
import math.geom2d.Point2D;
import math.geom2d.Vector2D;
import math.geom2d.circulinear.CirculinearContinuousCurve2D;
import math.geom2d.circulinear.buffer.CapFactory;
import math.geom2d.polygon.Polyline2D;

public class SquareCapFactory
implements CapFactory {
    public CirculinearContinuousCurve2D createCap(Point2D center, Vector2D direction, double dist) {
        double theta = direction.angle();
        return this.createCap(center, theta, dist);
    }

    public CirculinearContinuousCurve2D createCap(Point2D p1, Point2D p2) {
        Point2D center = Point2D.midPoint(p1, p2);
        double dist = Point2D.distance(p1, p2) / 2.0;
        double theta = Angle2D.horizontalAngle(p1, p2) - 1.5707963267948966;
        return this.createCap(center, theta, dist);
    }

    private Polyline2D createCap(Point2D center, double theta, double dist) {
        Point2D p1 = Point2D.createPolar(center, dist, theta - 1.5707963267948966);
        Point2D p4 = Point2D.createPolar(center, dist, theta + 1.5707963267948966);
        Point2D p2 = Point2D.createPolar(p1, dist, theta);
        Point2D p3 = Point2D.createPolar(p4, dist, theta);
        return new Polyline2D(p1, p2, p3, p4);
    }
}

