/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.stream;

import java.io.IOException;
import java.io.ObjectOutputStream;
import org.jboss.util.stream.ObjectOutputStreamAdapter;

public class AutoResetObjectOutputStream
extends ObjectOutputStreamAdapter {
    protected int after;
    protected int count;

    public AutoResetObjectOutputStream(ObjectOutputStream out, int after) throws IOException {
        super(out);
        this.setResetAfter(after);
    }

    public void setResetAfter(int after) {
        if (after <= 0) {
            throw new IllegalArgumentException("after <= 0");
        }
        this.after = after;
    }

    public final int getResetAfter() {
        return this.after;
    }

    public final int getCount() {
        return this.count;
    }

    protected void writeObjectOverride(Object obj) throws IOException {
        super.writeObjectOverride(obj);
        ++this.count;
        if (this.count >= this.after) {
            this.reset();
        }
    }

    public void reset() throws IOException {
        this.out.reset();
        this.count = 0;
    }
}

