/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class LazyList
implements List {
    private List delegate = Collections.EMPTY_LIST;

    public void add(int index, Object element) {
        if (!(this.delegate instanceof ArrayList)) {
            this.delegate = new ArrayList(this.delegate);
        }
        this.delegate.add(index, element);
    }

    public boolean add(Object o) {
        if (this.delegate == Collections.EMPTY_LIST) {
            this.delegate = Collections.singletonList(o);
            return true;
        }
        if (!(this.delegate instanceof ArrayList)) {
            this.delegate = new ArrayList(this.delegate);
        }
        return this.delegate.add(o);
    }

    public boolean addAll(Collection c) {
        if (!(this.delegate instanceof ArrayList)) {
            this.delegate = new ArrayList(this.delegate);
        }
        return this.delegate.addAll(c);
    }

    public boolean addAll(int index, Collection c) {
        if (!(this.delegate instanceof ArrayList)) {
            this.delegate = new ArrayList(this.delegate);
        }
        return this.delegate.addAll(index, c);
    }

    public void clear() {
        this.delegate = Collections.EMPTY_LIST;
    }

    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    public boolean containsAll(Collection c) {
        return this.delegate.containsAll(c);
    }

    public Object get(int index) {
        return this.delegate.get(index);
    }

    public int indexOf(Object o) {
        return this.delegate.indexOf(o);
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public Iterator iterator() {
        return this.delegate.iterator();
    }

    public int lastIndexOf(Object o) {
        return this.delegate.lastIndexOf(o);
    }

    public ListIterator listIterator() {
        return this.delegate.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.delegate.listIterator(index);
    }

    public Object remove(int index) {
        if (!(this.delegate instanceof ArrayList)) {
            this.delegate = new ArrayList(this.delegate);
        }
        return this.delegate.remove(index);
    }

    public boolean remove(Object o) {
        if (!(this.delegate instanceof ArrayList)) {
            this.delegate = new ArrayList(this.delegate);
        }
        return this.delegate.remove(o);
    }

    public boolean removeAll(Collection c) {
        if (!(this.delegate instanceof ArrayList)) {
            this.delegate = new ArrayList(this.delegate);
        }
        return this.delegate.remove(c);
    }

    public boolean retainAll(Collection c) {
        if (!(this.delegate instanceof ArrayList)) {
            this.delegate = new ArrayList(this.delegate);
        }
        return this.delegate.retainAll(c);
    }

    public Object set(int index, Object element) {
        if (!(this.delegate instanceof ArrayList)) {
            this.delegate = new ArrayList(this.delegate);
        }
        return this.delegate.set(index, element);
    }

    public int size() {
        return this.delegate.size();
    }

    public List subList(int fromIndex, int toIndex) {
        return this.delegate.subList(fromIndex, toIndex);
    }

    public Object[] toArray() {
        return this.delegate.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.delegate.toArray(a);
    }
}

