/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.shorts.AbstractShortComparator;
import it.unimi.dsi.fastutil.shorts.ShortComparator;

public class ShortComparators {
    public static final ShortComparator NATURAL_COMPARATOR = new AbstractShortComparator(){

        @Override
        public final int compare(short a, short b) {
            return Short.compare(a, b);
        }
    };
    public static final ShortComparator OPPOSITE_COMPARATOR = new AbstractShortComparator(){

        @Override
        public final int compare(short a, short b) {
            return -Short.compare(a, b);
        }
    };

    private ShortComparators() {
    }

    public static ShortComparator oppositeComparator(final ShortComparator c) {
        return new AbstractShortComparator(){
            private final ShortComparator comparator;
            {
                this.comparator = c;
            }

            @Override
            public final int compare(short a, short b) {
                return -this.comparator.compare(a, b);
            }
        };
    }
}

