/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.activemq;

import java.io.IOException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import zipkin2.reporter.activemq.ActiveMQConn;
import zipkin2.reporter.activemq.ActiveMQSender;

final class LazyInit {
    final ActiveMQConnectionFactory connectionFactory;
    final String queue;
    volatile ActiveMQConn result;

    LazyInit(ActiveMQSender.Builder builder) {
        this.connectionFactory = builder.connectionFactory;
        this.queue = builder.queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ActiveMQConn get() throws IOException {
        if (this.result == null) {
            LazyInit lazyInit = this;
            synchronized (lazyInit) {
                if (this.result == null) {
                    this.result = this.doGet();
                }
            }
        }
        return this.result;
    }

    void close() {
        ActiveMQConn maybe = this.result;
        if (maybe != null) {
            this.result.close();
        }
    }

    ActiveMQConn doGet() throws IOException {
        ActiveMQConnection connection;
        try {
            connection = (ActiveMQConnection)this.connectionFactory.createQueueConnection();
            connection.start();
        }
        catch (JMSException e) {
            throw ActiveMQSender.ioException("Unable to establish connection to ActiveMQ broker: ", e);
        }
        try {
            QueueSession session = connection.createQueueSession(false, 1);
            Queue destination = session.createQueue(this.queue);
            QueueSender sender = session.createSender(destination);
            return new ActiveMQConn(connection, session, sender);
        }
        catch (JMSException e) {
            try {
                connection.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            throw ActiveMQSender.ioException("Unable to create queueSender(" + this.queue + "): ", e);
        }
    }
}

