/*
 * Decompiled with CFR 0.152.
 */
package zipkin.collector.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Address;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import zipkin.Component;
import zipkin.SpanDecoder;
import zipkin.collector.Collector;
import zipkin.collector.CollectorComponent;
import zipkin.collector.CollectorMetrics;
import zipkin.collector.CollectorSampler;
import zipkin.internal.LazyCloseable;
import zipkin.internal.Util;
import zipkin.storage.Callback;
import zipkin.storage.StorageComponent;

public final class RabbitMQCollector
implements CollectorComponent {
    final String queue;
    final LazyInit connection;

    public static Builder builder() {
        return new Builder();
    }

    RabbitMQCollector(Builder builder) {
        this.queue = builder.queue;
        this.connection = new LazyInit(builder);
    }

    public RabbitMQCollector start() {
        this.connection.get();
        return this;
    }

    public Component.CheckResult check() {
        try {
            Component.CheckResult failure = this.connection.failure.get();
            if (failure != null) {
                return failure;
            }
            return Component.CheckResult.OK;
        }
        catch (RuntimeException e) {
            return Component.CheckResult.failed((Exception)e);
        }
    }

    public void close() throws IOException {
        this.connection.close();
    }

    static Address[] convertAddresses(List<String> addresses) {
        Address[] addressArray = new Address[addresses.size()];
        for (int i = 0; i < addresses.size(); ++i) {
            String[] splitAddress = addresses.get(i).split(":");
            String host = splitAddress[0];
            Integer port = null;
            try {
                if (splitAddress.length == 2) {
                    port = Integer.parseInt(splitAddress[1]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            addressArray[i] = port != null ? new Address(host, port.intValue()) : new Address(host);
        }
        return addressArray;
    }

    static class RabbitMQSpanConsumer
    extends DefaultConsumer {
        final Collector collector;
        final CollectorMetrics metrics;

        RabbitMQSpanConsumer(Channel channel, Collector collector, CollectorMetrics metrics) {
            super(channel);
            this.collector = collector;
            this.metrics = metrics;
        }

        public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
            this.metrics.incrementMessages();
            this.collector.acceptSpans(body, SpanDecoder.DETECTING_DECODER, Callback.NOOP);
        }
    }

    static final class LazyInit
    extends LazyCloseable<Connection> {
        final Builder builder;
        final AtomicReference<Component.CheckResult> failure = new AtomicReference();

        LazyInit(Builder builder) {
            this.builder = builder;
        }

        protected Connection compute() {
            Connection connection;
            try {
                connection = this.builder.addresses == null ? this.builder.connectionFactory.newConnection() : this.builder.connectionFactory.newConnection(this.builder.addresses);
                connection.createChannel().queueDeclare(this.builder.queue, true, false, false, null);
            }
            catch (IOException | TimeoutException e) {
                throw new IllegalStateException("Unable to establish connection to RabbitMQ server", e);
            }
            Collector collector = this.builder.delegate.build();
            CollectorMetrics metrics = this.builder.metrics;
            for (int i = 0; i < this.builder.concurrency; ++i) {
                String name = RabbitMQSpanConsumer.class.getName() + i;
                try {
                    Channel channel = connection.createChannel();
                    RabbitMQSpanConsumer consumer = new RabbitMQSpanConsumer(channel, collector, metrics);
                    channel.basicConsume(this.builder.queue, true, name, (Consumer)consumer);
                    continue;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to start RabbitMQ consumer " + name, e);
                }
            }
            return connection;
        }
    }

    public static final class Builder
    implements CollectorComponent.Builder {
        Collector.Builder delegate = Collector.builder(RabbitMQCollector.class);
        CollectorMetrics metrics = CollectorMetrics.NOOP_METRICS;
        String queue = "zipkin";
        ConnectionFactory connectionFactory = new ConnectionFactory();
        Address[] addresses;
        int concurrency = 1;

        public Builder storage(StorageComponent storage) {
            this.delegate.storage(storage);
            return this;
        }

        public Builder sampler(CollectorSampler sampler) {
            this.delegate.sampler(sampler);
            return this;
        }

        public Builder metrics(CollectorMetrics metrics) {
            this.metrics = ((CollectorMetrics)Util.checkNotNull((Object)metrics, (String)"metrics")).forTransport("rabbitmq");
            this.delegate.metrics(this.metrics);
            return this;
        }

        public Builder addresses(List<String> addresses) {
            this.addresses = RabbitMQCollector.convertAddresses(addresses);
            return this;
        }

        public Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            return this;
        }

        public Builder connectionFactory(ConnectionFactory connectionFactory) {
            this.connectionFactory = (ConnectionFactory)Util.checkNotNull((Object)connectionFactory, (String)"connectionFactory");
            return this;
        }

        public Builder queue(String queue) {
            this.queue = (String)Util.checkNotNull((Object)queue, (String)"queue");
            return this;
        }

        public RabbitMQCollector build() {
            return new RabbitMQCollector(this);
        }
    }
}

