/*
 * Decompiled with CFR 0.152.
 */
package brave.propagation.tracecontext;

import brave.propagation.B3SingleFormat;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import brave.propagation.tracecontext.TraceContextPropagation;
import brave.propagation.tracecontext.TraceparentFormat;
import brave.propagation.tracecontext.Tracestate;
import brave.propagation.tracecontext.TracestateFormat;
import brave.propagation.tracecontext.internal.CharSequences;
import java.util.Arrays;

final class TraceContextExtractor<R>
implements TraceContext.Extractor<R> {
    final Propagation.Getter<R, String> getter;
    final TraceparentFormat traceparentFormat;
    final TracestateFormat tracestateFormat;
    final String tracestateKey;

    TraceContextExtractor(TraceContextPropagation propagation, Propagation.Getter<R, String> getter) {
        this.getter = getter;
        this.traceparentFormat = propagation.traceparentFormat;
        this.tracestateFormat = propagation.tracestateFormat;
        this.tracestateKey = propagation.tracestateKey;
    }

    public TraceContextOrSamplingFlags extract(R request) {
        if (request == null) {
            throw new NullPointerException("request == null");
        }
        String traceparentString = this.getter.get(request, (Object)"traceparent");
        if (traceparentString == null) {
            return TraceContextOrSamplingFlags.EMPTY;
        }
        String tracestateString = this.getter.get(request, (Object)"tracestate");
        if (tracestateString == null) {
            return TraceContextOrSamplingFlags.EMPTY;
        }
        TraceContext maybeUpstream = this.traceparentFormat.parse(traceparentString);
        if (maybeUpstream == null) {
            return TraceContextOrSamplingFlags.EMPTY;
        }
        int[] indices = new int[6];
        Arrays.fill(indices, -1);
        if (!this.tracestateFormat.parseInto(tracestateString, indices)) {
            return TraceContextOrSamplingFlags.EMPTY;
        }
        if (indices[1] != -1) {
            TraceContextOrSamplingFlags fromB3Entry = B3SingleFormat.parseB3SingleFormat((CharSequence)tracestateString, (int)indices[3], (int)indices[4]);
            if (fromB3Entry == null) {
                return TraceContextOrSamplingFlags.EMPTY;
            }
            Tracestate tracestate = Tracestate.create(TraceContextExtractor.withoutB3(tracestateString, indices));
            return fromB3Entry.toBuilder().addExtra((Object)tracestate).build();
        }
        return TraceContextOrSamplingFlags.newBuilder((TraceContext)maybeUpstream).addExtra((Object)Tracestate.create(tracestateString)).build();
    }

    static CharSequence withoutB3(String tracestateString, int[] indices) {
        int firstIndexToSkip;
        if (indices[0] == -1 && indices[5] == -1) {
            return "";
        }
        int n = firstIndexToSkip = indices[0] != -1 ? tracestateString.indexOf(44, indices[0]) : 0;
        if (indices[4] != tracestateString.length() && firstIndexToSkip != 0) {
            ++firstIndexToSkip;
        }
        return CharSequences.withoutSubSequence(tracestateString, firstIndexToSkip, indices[5] != -1 ? indices[5] : indices[4]);
    }
}

