/*
 * Decompiled with CFR 0.152.
 */
package brave.cassandra.driver;

import brave.Tracing;
import brave.cassandra.driver.CassandraClientParser;
import brave.cassandra.driver.CassandraClientSampler;
import brave.internal.Nullable;

public final class CassandraClientTracing {
    final Tracing tracing;
    final CassandraClientParser parser;
    final CassandraClientSampler sampler;
    final boolean propagationEnabled;
    @Nullable
    final String remoteServiceName;

    public static CassandraClientTracing create(Tracing tracing) {
        return CassandraClientTracing.newBuilder(tracing).build();
    }

    public static Builder newBuilder(Tracing tracing) {
        if (tracing == null) {
            throw new NullPointerException("tracing == null");
        }
        return new Builder(tracing);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    CassandraClientTracing(Builder builder) {
        this.tracing = builder.tracing;
        this.parser = builder.parser;
        this.sampler = builder.sampler;
        this.propagationEnabled = builder.propagationEnabled;
        this.remoteServiceName = builder.remoteServiceName;
    }

    public Tracing tracing() {
        return this.tracing;
    }

    public CassandraClientParser parser() {
        return this.parser;
    }

    @Nullable
    public String remoteServiceName() {
        return this.remoteServiceName;
    }

    public CassandraClientTracing clientOf(String remoteServiceName) {
        return this.toBuilder().remoteServiceName(remoteServiceName).build();
    }

    public boolean propagationEnabled() {
        return this.propagationEnabled;
    }

    public CassandraClientSampler sampler() {
        return this.sampler;
    }

    public static final class Builder {
        final Tracing tracing;
        CassandraClientParser parser = new CassandraClientParser();
        CassandraClientSampler sampler = CassandraClientSampler.TRACE_ID;
        boolean propagationEnabled = false;
        String remoteServiceName;

        Builder(Tracing tracing) {
            this.tracing = tracing;
        }

        Builder(CassandraClientTracing source) {
            this.tracing = source.tracing;
            this.parser = source.parser;
            this.sampler = source.sampler;
            this.propagationEnabled = source.propagationEnabled;
            this.remoteServiceName = source.remoteServiceName;
        }

        public Builder parser(CassandraClientParser parser) {
            if (parser == null) {
                throw new NullPointerException("parser == null");
            }
            this.parser = parser;
            return this;
        }

        public Builder sampler(CassandraClientSampler sampler) {
            if (sampler == null) {
                throw new NullPointerException("sampler == null");
            }
            this.sampler = sampler;
            return this;
        }

        public Builder propagationEnabled(boolean propagationEnabled) {
            this.propagationEnabled = propagationEnabled;
            return this;
        }

        public Builder remoteServiceName(@Nullable String remoteServiceName) {
            this.remoteServiceName = remoteServiceName;
            return this;
        }

        public CassandraClientTracing build() {
            return new CassandraClientTracing(this);
        }
    }
}

