/*
 * Decompiled with CFR 0.152.
 */
package brave.cassandra.driver;

import brave.SpanCustomizer;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import com.google.common.base.CaseFormat;

public class CassandraClientParser {
    public void request(Statement statement, SpanCustomizer customizer) {
        customizer.name(this.spanName(statement));
        String keyspace = statement.getKeyspace();
        if (keyspace != null) {
            customizer.tag("cassandra.keyspace", statement.getKeyspace());
        }
        if (statement instanceof BoundStatement) {
            customizer.tag("cassandra.query", ((BoundStatement)statement).preparedStatement().getQueryString());
        }
    }

    protected String spanName(Statement statement) {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, statement.getClass().getSimpleName());
    }

    public void response(ResultSet resultSet, SpanCustomizer customizer) {
    }
}

