/*
 * Decompiled with CFR 0.152.
 */
package brave.http;

import brave.SpanCustomizer;
import brave.http.HttpAdapter;
import brave.internal.Nullable;

public class HttpParser {
    public <Req> void request(HttpAdapter<Req, ?> adapter, Req req, SpanCustomizer customizer) {
        String path;
        customizer.name(this.spanName(adapter, req));
        String method = adapter.method(req);
        if (method != null) {
            customizer.tag("http.method", method);
        }
        if ((path = adapter.path(req)) != null) {
            customizer.tag("http.path", path);
        }
    }

    protected <Req> String spanName(HttpAdapter<Req, ?> adapter, Req req) {
        return adapter.method(req);
    }

    public <Resp> void response(HttpAdapter<?, Resp> adapter, @Nullable Resp res, @Nullable Throwable error, SpanCustomizer customizer) {
        int statusCode = 0;
        if (res != null) {
            statusCode = adapter.statusCodeAsInt(res);
            String nameFromRoute = HttpParser.spanNameFromRoute(adapter, res, statusCode);
            if (nameFromRoute != null) {
                customizer.name(nameFromRoute);
            }
            if (statusCode != 0 && (statusCode < 200 || statusCode > 299)) {
                customizer.tag("http.status_code", String.valueOf(statusCode));
            }
        }
        this.error(statusCode, error, customizer);
    }

    static <Resp> String spanNameFromRoute(HttpAdapter<?, Resp> adapter, Resp res, int statusCode) {
        String method = adapter.methodFromResponse(res);
        if (method == null) {
            return null;
        }
        String route = adapter.route(res);
        if (route == null) {
            return null;
        }
        if (!"".equals(route)) {
            return method + " " + route;
        }
        if (statusCode / 100 == 3) {
            return method + " redirected";
        }
        if (statusCode == 404) {
            return method + " not_found";
        }
        return null;
    }

    protected void error(@Nullable Integer httpStatus, @Nullable Throwable error, SpanCustomizer customizer) {
        String message = null;
        if (error != null) {
            message = error.getMessage();
            if (message == null) {
                message = error.getClass().getSimpleName();
            }
        } else if (httpStatus != null && httpStatus != 0) {
            String string = message = httpStatus < 200 || httpStatus > 399 ? String.valueOf(httpStatus) : null;
        }
        if (message != null) {
            customizer.tag("error", message);
        }
    }

    HttpParser() {
    }
}

