/*
 * Decompiled with CFR 0.152.
 */
package brave.propagation.aws;

import brave.Tracing;
import brave.baggage.BaggageField;
import brave.internal.Nullable;
import brave.internal.propagation.StringPropagationAdapter;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import brave.propagation.aws.AWSExtractor;
import brave.propagation.aws.AWSInjector;
import brave.propagation.aws.HexCodec;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class AWSPropagation
implements Propagation<String> {
    static final String AMZN_TRACE_ID_NAME = "x-amzn-trace-id";
    static final BaggageField FIELD_AMZN_TRACE_ID = BaggageField.create((String)"x-amzn-trace-id");
    static final Propagation<String> INSTANCE = new AWSPropagation();
    static final AmznTraceId EXTRA_MARKER = new AmznTraceId();
    static final TraceContext.Extractor<String> STRING_EXTRACTOR = INSTANCE.extractor((Propagation.Getter)new Propagation.Getter<String, String>(){

        public String get(String request, String key) {
            return request;
        }
    });
    public static final Propagation.Factory FACTORY = new Factory();
    static final char[] ROOT = "Root=".toCharArray();
    static final char[] PARENT = ";Parent=".toCharArray();
    static final char[] SAMPLED = ";Sampled=".toCharArray();
    static final int ROOT_LENGTH = 35;
    final List<String> keyNames = Collections.unmodifiableList(Arrays.asList("x-amzn-trace-id"));

    AWSPropagation() {
    }

    public List<String> keys() {
        return this.keyNames;
    }

    public <R> TraceContext.Injector<R> injector(Propagation.Setter<R, String> setter) {
        if (setter == null) {
            throw new NullPointerException("setter == null");
        }
        return new AWSInjector<R>(this, setter);
    }

    @Nullable
    public static String currentTraceId() {
        Tracing tracing = Tracing.current();
        if (tracing == null) {
            return null;
        }
        TraceContext context = tracing.currentTraceContext().get();
        if (context == null) {
            return null;
        }
        return AWSPropagation.traceId(context);
    }

    @Nullable
    public static String traceId(TraceContext context) {
        int length = context.extra().size();
        for (int i = 0; i < length; ++i) {
            Object next = context.extra().get(i);
            if (!(next instanceof AmznTraceId)) continue;
            char[] result = new char[35];
            AWSPropagation.writeRoot(context, result, 0);
            return new String(result);
        }
        String maybeHeader = FIELD_AMZN_TRACE_ID.getValue(context);
        if (maybeHeader == null) {
            return null;
        }
        int i = maybeHeader.indexOf("Root=");
        if (i == -1) {
            return null;
        }
        if (maybeHeader.length() < (i += 5) + 35) {
            return null;
        }
        return maybeHeader.substring(i, i + 35);
    }

    static void writeRoot(TraceContext context, char[] result, int offset) {
        result[offset] = 49;
        result[offset + 1] = 45;
        long high = context.traceIdHigh();
        HexCodec.writeHexByte(result, offset + 2, (byte)(high >>> 56 & 0xFFL));
        HexCodec.writeHexByte(result, offset + 4, (byte)(high >>> 48 & 0xFFL));
        HexCodec.writeHexByte(result, offset + 6, (byte)(high >>> 40 & 0xFFL));
        HexCodec.writeHexByte(result, offset + 8, (byte)(high >>> 32 & 0xFFL));
        result[offset + 10] = 45;
        HexCodec.writeHexByte(result, offset + 11, (byte)(high >>> 24 & 0xFFL));
        HexCodec.writeHexByte(result, offset + 13, (byte)(high >>> 16 & 0xFFL));
        HexCodec.writeHexByte(result, offset + 15, (byte)(high >>> 8 & 0xFFL));
        HexCodec.writeHexByte(result, offset + 17, (byte)(high & 0xFFL));
        HexCodec.writeHexLong(result, offset + 19, context.traceId());
    }

    public <R> TraceContext.Extractor<R> extractor(Propagation.Getter<R, String> getter) {
        if (getter == null) {
            throw new NullPointerException("getter == null");
        }
        return new AWSExtractor<R>(this, getter);
    }

    public static TraceContextOrSamplingFlags extractLambda() {
        return AWSPropagation.extract(System.getenv("_X_AMZN_TRACE_ID"));
    }

    public static TraceContextOrSamplingFlags extract(String amznTraceId) {
        if (amznTraceId == null) {
            return AWSExtractor.EMPTY;
        }
        return STRING_EXTRACTOR.extract((Object)amznTraceId);
    }

    static final class AmznTraceId {
        CharSequence customFields;

        AmznTraceId() {
        }

        public String toString() {
            return "AmznTraceId{" + (this.customFields != null ? "customFields=" + this.customFields : "") + "}";
        }
    }

    static final class Factory
    extends Propagation.Factory {
        Factory() {
        }

        public Propagation<String> get() {
            return INSTANCE;
        }

        @Deprecated
        public <K> Propagation<K> create(Propagation.KeyFactory<K> keyFactory) {
            return StringPropagationAdapter.create(this.get(), keyFactory);
        }

        public boolean supportsJoin() {
            return false;
        }

        public boolean requires128BitTraceId() {
            return true;
        }

        public String toString() {
            return "AWSPropagationFactory";
        }
    }
}

