/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.ResponseTimeHandler;
import java.util.concurrent.TimeUnit;

public class ResponseTimeHandlerImpl
implements ResponseTimeHandler {
    private static final CharSequence HEADER_NAME = HttpHeaders.createOptimized((String)"x-response-time");

    public void handle(RoutingContext ctx) {
        long start = System.nanoTime();
        ctx.addHeadersEndHandler((Handler<Void>)((Handler)v -> {
            long duration = TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS);
            ctx.response().putHeader(HEADER_NAME, (CharSequence)(duration + "ms"));
        }));
        ctx.next();
    }
}

