/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.sockjs.SockJSHandlerOptions;
import io.vertx.ext.web.handler.sockjs.SockJSSocket;
import io.vertx.ext.web.handler.sockjs.impl.BaseTransport;
import io.vertx.ext.web.handler.sockjs.impl.SockJSSocketBase;

class RawWebSocketTransport {
    RawWebSocketTransport(Vertx vertx, Router router, SockJSHandlerOptions options, Handler<SockJSSocket> sockHandler) {
        String wsRE = "/websocket";
        router.get(wsRE).handler((Handler<RoutingContext>)((Handler)rc -> {
            rc.request().pause();
            rc.request().toWebSocket(toWebSocket -> {
                if (toWebSocket.succeeded()) {
                    rc.request().resume();
                    RawWSSockJSSocket sock = new RawWSSockJSSocket(vertx, rc.session(), rc.user(), options, (ServerWebSocket)toWebSocket.result());
                    sockHandler.handle((Object)sock);
                } else {
                    rc.fail(toWebSocket.cause());
                }
            });
        }));
        router.get(wsRE).handler((Handler<RoutingContext>)((Handler)rc -> rc.response().setStatusCode(400).end("Can \"Upgrade\" only to \"WebSocket\".")));
        router.get(wsRE).handler((Handler<RoutingContext>)((Handler)rc -> rc.response().putHeader(HttpHeaders.ALLOW, (CharSequence)"GET").setStatusCode(405).end()));
    }

    private static class RawWSSockJSSocket
    extends SockJSSocketBase {
        final ServerWebSocket ws;
        MultiMap headers;
        boolean closed;

        RawWSSockJSSocket(Vertx vertx, Session webSession, User webUser, SockJSHandlerOptions options, ServerWebSocket ws) {
            super(vertx, webSession, webUser, options);
            this.ws = ws;
            ws.closeHandler(v -> {
                RawWSSockJSSocket rawWSSockJSSocket = this;
                synchronized (rawWSSockJSSocket) {
                    this.closed = true;
                }
                RawWSSockJSSocket.super.close();
            });
        }

        @Override
        public SockJSSocket handler(Handler<Buffer> handler) {
            this.ws.binaryMessageHandler(handler);
            this.ws.textMessageHandler(textMessage -> handler.handle((Object)Buffer.buffer((String)textMessage)));
            return this;
        }

        @Override
        public SockJSSocket pause() {
            this.ws.pause();
            return this;
        }

        @Override
        public SockJSSocket resume() {
            this.ws.resume();
            return this;
        }

        @Override
        public SockJSSocket fetch(long amount) {
            this.ws.fetch(amount);
            return this;
        }

        private synchronized boolean canWrite(Handler<AsyncResult<Void>> handler) {
            if (this.closed) {
                if (handler != null) {
                    this.vertx.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)ConnectionBase.CLOSED_EXCEPTION)));
                }
                return false;
            }
            return true;
        }

        @Override
        public void write(Buffer data, Handler<AsyncResult<Void>> handler) {
            if (this.canWrite(handler)) {
                this.ws.writeBinaryMessage(data, handler);
            }
        }

        @Override
        public void write(String data, Handler<AsyncResult<Void>> handler) {
            if (this.canWrite(handler)) {
                this.ws.writeTextMessage(data, handler);
            }
        }

        @Override
        public SockJSSocket setWriteQueueMaxSize(int maxQueueSize) {
            this.ws.setWriteQueueMaxSize(maxQueueSize);
            return this;
        }

        public boolean writeQueueFull() {
            return this.ws.writeQueueFull();
        }

        @Override
        public SockJSSocket drainHandler(Handler<Void> handler) {
            this.ws.drainHandler(handler);
            return this;
        }

        @Override
        public SockJSSocket exceptionHandler(Handler<Throwable> handler) {
            this.ws.exceptionHandler(handler);
            return this;
        }

        @Override
        public SockJSSocket endHandler(Handler<Void> endHandler) {
            this.ws.endHandler(endHandler);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            RawWSSockJSSocket rawWSSockJSSocket = this;
            synchronized (rawWSSockJSSocket) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            super.close();
            this.ws.close();
        }

        @Override
        public void closeAfterSessionExpired() {
            this.close(1001, "Session expired");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close(int statusCode, String reason) {
            RawWSSockJSSocket rawWSSockJSSocket = this;
            synchronized (rawWSSockJSSocket) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            super.close();
            this.ws.close((short)statusCode, reason);
        }

        @Override
        public SocketAddress remoteAddress() {
            return this.ws.remoteAddress();
        }

        @Override
        public SocketAddress localAddress() {
            return this.ws.localAddress();
        }

        @Override
        public MultiMap headers() {
            if (this.headers == null) {
                this.headers = BaseTransport.removeCookieHeaders(this.ws.headers());
            }
            return this.headers;
        }

        @Override
        public String uri() {
            return this.ws.uri();
        }
    }
}

