/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl.pool;

import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.ConnectionFactory;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.spi.DatabaseMetadata;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class ConnectionPool {
    private final ConnectionFactory connector;
    private final ContextInternal context;
    private final int maxSize;
    private final ArrayDeque<Handler<AsyncResult<Connection>>> waiters = new ArrayDeque();
    private final Set<PooledConnection> all = new HashSet<PooledConnection>();
    private final ArrayDeque<PooledConnection> available = new ArrayDeque();
    private int size;
    private final int maxWaitQueueSize;
    private boolean checkInProgress;
    private boolean closed;

    public ConnectionPool(ConnectionFactory connector, int maxSize) {
        this(connector, maxSize, -1);
    }

    public ConnectionPool(ConnectionFactory connector, int maxSize, int maxWaitQueueSize) {
        this(connector, null, maxSize, maxWaitQueueSize);
    }

    public ConnectionPool(ConnectionFactory connector, Context context, int maxSize, int maxWaitQueueSize) {
        Objects.requireNonNull(connector, "No null connector");
        if (maxSize < 1) {
            throw new IllegalArgumentException("Pool max size must be > 0");
        }
        this.maxSize = maxSize;
        this.context = (ContextInternal)context;
        this.maxWaitQueueSize = maxWaitQueueSize;
        this.connector = connector;
    }

    public int available() {
        return this.available.size();
    }

    public int size() {
        return this.size;
    }

    public void acquire(Handler<AsyncResult<Connection>> waiter) {
        if (this.context != null) {
            this.context.emit(waiter, this::doAcquire);
        } else {
            this.doAcquire(waiter);
        }
    }

    private void doAcquire(Handler<AsyncResult<Connection>> waiter) {
        if (this.closed) {
            IllegalStateException err = new IllegalStateException("Connection pool closed");
            if (this.context != null) {
                waiter.handle((Object)this.context.failedFuture((Throwable)err));
            } else {
                waiter.handle((Object)Future.failedFuture((Throwable)err));
            }
            return;
        }
        this.waiters.add(waiter);
        this.check();
    }

    public Future<Void> close() {
        PromiseInternal promise = this.context.promise();
        this.context.emit((Object)promise, this::close);
        return promise.future();
    }

    public void close(Promise<Void> promise) {
        if (this.closed) {
            promise.fail("Connection pool already closed");
            return;
        }
        this.closed = true;
        Future failure = Future.failedFuture((String)"Connection pool closed");
        for (Handler<AsyncResult<Connection>> pending : this.waiters) {
            try {
                pending.handle((Object)failure);
            }
            catch (Exception exception) {}
        }
        ArrayList<Future> futures = new ArrayList<Future>();
        for (PooledConnection pooled : new ArrayList<PooledConnection>(this.all)) {
            Promise p = Promise.promise();
            pooled.close((Promise<Void>)p);
            futures.add(p.future());
        }
        CompositeFuture.join(futures).mapEmpty().onComplete(promise);
    }

    private void release(PooledConnection proxy) {
        if (this.all.contains(proxy)) {
            this.available.add(proxy);
            this.check();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check() {
        if (this.closed) {
            return;
        }
        if (!this.checkInProgress) {
            this.checkInProgress = true;
            try {
                while (this.waiters.size() > 0) {
                    if (this.available.size() > 0) {
                        PooledConnection proxy = this.available.poll();
                        Handler<AsyncResult<Connection>> waiter = this.waiters.poll();
                        waiter.handle((Object)Future.succeededFuture((Object)proxy));
                        continue;
                    }
                    if (this.size < this.maxSize) {
                        Handler<AsyncResult<Connection>> waiter = this.waiters.poll();
                        ++this.size;
                        this.connector.connect().onComplete(ar -> {
                            if (ar.succeeded()) {
                                Connection conn = (Connection)ar.result();
                                PooledConnection proxy = new PooledConnection(conn);
                                this.all.add(proxy);
                                conn.init(proxy);
                                waiter.handle((Object)Future.succeededFuture((Object)proxy));
                            } else {
                                --this.size;
                                waiter.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                                this.check();
                            }
                        });
                        continue;
                    }
                    if (this.maxWaitQueueSize >= 0) {
                        int numInProgress = this.size - this.all.size();
                        int numToFail = this.waiters.size() - (this.maxWaitQueueSize + numInProgress);
                        while (numToFail-- > 0) {
                            Handler<AsyncResult<Connection>> waiter = this.waiters.pollLast();
                            waiter.handle((Object)Future.failedFuture((String)"Max waiter size reached"));
                        }
                    }
                    break;
                }
            }
            finally {
                this.checkInProgress = false;
            }
        }
    }

    private class PooledConnection
    implements Connection,
    Connection.Holder {
        private final Connection conn;
        private Connection.Holder holder;

        PooledConnection(Connection conn) {
            this.conn = conn;
        }

        @Override
        public boolean isSsl() {
            return this.conn.isSsl();
        }

        @Override
        public DatabaseMetadata getDatabaseMetaData() {
            return this.conn.getDatabaseMetaData();
        }

        @Override
        public <R> void schedule(CommandBase<R> cmd, Promise<R> handler) {
            this.conn.schedule(cmd, handler);
        }

        private void close(Promise<Void> promise) {
            this.conn.close(this, promise);
        }

        @Override
        public void init(Connection.Holder holder) {
            if (this.holder != null) {
                throw new IllegalStateException();
            }
            this.holder = holder;
        }

        @Override
        public void close(Connection.Holder holder, Promise<Void> promise) {
            if (ConnectionPool.this.context != null) {
                ConnectionPool.this.context.emit(v -> this.doClose(holder, promise));
            } else {
                this.doClose(holder, promise);
            }
        }

        private void doClose(Connection.Holder holder, Promise<Void> promise) {
            if (holder != this.holder) {
                String msg = this.holder == null ? "Connection released twice" : "Connection released by " + holder + " owned by " + this.holder;
                promise.fail(msg);
                return;
            }
            this.holder = null;
            ConnectionPool.this.release(this);
            promise.complete();
        }

        @Override
        public void handleClosed() {
            if (ConnectionPool.this.all.remove(this)) {
                ConnectionPool.this.size--;
                if (this.holder == null) {
                    ConnectionPool.this.available.remove(this);
                } else {
                    this.holder.handleClosed();
                }
            } else {
                throw new IllegalStateException();
            }
            ConnectionPool.this.check();
        }

        @Override
        public void handleEvent(Object event) {
            if (this.holder != null) {
                this.holder.handleEvent(event);
            }
        }

        @Override
        public void handleException(Throwable err) {
            if (this.holder != null) {
                this.holder.handleException(err);
            }
        }

        @Override
        public int getProcessId() {
            return this.conn.getProcessId();
        }

        @Override
        public int getSecretKey() {
            return this.conn.getSecretKey();
        }
    }
}

