/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl.cache;

import io.vertx.sqlclient.impl.PreparedStatement;
import io.vertx.sqlclient.impl.cache.LruCache;
import java.util.List;

public class PreparedStatementCache {
    private final int capacity;
    private final LruCache<String, PreparedStatement> cache;

    public PreparedStatementCache(int cacheCapacity) {
        this.capacity = cacheCapacity;
        this.cache = new LruCache(cacheCapacity);
    }

    public PreparedStatement get(String sql) {
        return (PreparedStatement)this.cache.get(sql);
    }

    public List<PreparedStatement> put(PreparedStatement preparedStatement) {
        return this.cache.cache(preparedStatement.sql(), preparedStatement);
    }

    public void remove(String sql) {
        this.cache.remove(sql);
    }

    public PreparedStatement evict() {
        return this.cache.evict();
    }

    public boolean isFull() {
        return this.cache.size() == this.capacity;
    }

    public int size() {
        return this.cache.size();
    }
}

