/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.VertxException;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.sqlclient.Transaction;
import io.vertx.sqlclient.TransactionRollbackException;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.command.TxCommand;
import java.util.ArrayDeque;
import java.util.Deque;

class TransactionImpl
implements Transaction {
    private static final int ST_BEGIN = 0;
    private static final int ST_PENDING = 1;
    private static final int ST_PROCESSING = 2;
    private static final int ST_COMPLETED = 3;
    private final ContextInternal context;
    private final Connection connection;
    private final Deque<CommandBase<?>> pending = new ArrayDeque();
    private int status = 0;
    private final Promise<Void> completion;

    TransactionImpl(ContextInternal context, Connection connection) {
        this.context = context;
        this.connection = connection;
        this.completion = context.promise();
    }

    Future<Transaction> begin() {
        PromiseInternal promise = this.context.promise(this::afterBegin);
        TxCommand<TransactionImpl> begin = new TxCommand<TransactionImpl>(TxCommand.Kind.BEGIN, this);
        begin.handler = this.wrap((Promise)promise);
        this.execute(begin);
        return promise.future();
    }

    private <R> void execute(CommandBase<R> cmd) {
        this.connection.schedule(cmd, this.context.promise(cmd.handler));
    }

    private <T> Handler<AsyncResult<T>> wrap(Promise<T> handler) {
        return ar -> {
            TransactionImpl transactionImpl = this;
            synchronized (transactionImpl) {
                if (this.status == 2) {
                    this.status = 1;
                }
            }
            if (ar.failed()) {
                this.rollback((Handler<AsyncResult<Void>>)((Handler)a -> handler.handle(ar)));
            } else {
                handler.handle(ar);
                this.checkPending();
            }
        };
    }

    private synchronized void afterBegin(AsyncResult<Transaction> ar) {
        this.status = ar.succeeded() ? 1 : 3;
        this.checkPending();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPending() {
        while (true) {
            CommandBase<?> cmd;
            TransactionImpl transactionImpl = this;
            synchronized (transactionImpl) {
                switch (this.status) {
                    case 1: {
                        cmd = this.pending.poll();
                        if (cmd != null) {
                            this.status = 2;
                            this.execute(cmd);
                        }
                        return;
                    }
                    case 3: {
                        cmd = this.pending.poll();
                        if (cmd != null) break;
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            VertxException err = new VertxException("Transaction already completed", false);
            cmd.fail((Throwable)err);
        }
    }

    public <R> void schedule(CommandBase<R> cmd, Promise<R> handler) {
        cmd.handler = this.wrap(handler);
        this.schedule(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> void schedule(CommandBase<R> b) {
        TransactionImpl transactionImpl = this;
        synchronized (transactionImpl) {
            this.pending.add(b);
        }
        this.checkPending();
    }

    @Override
    public Future<Void> commit() {
        PromiseInternal promise = this.context.promise();
        TxCommand<Void> commit = this.txCommand(TxCommand.Kind.COMMIT, (Promise<Void>)promise);
        this.schedule(commit);
        return promise.future();
    }

    @Override
    public void commit(Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.commit();
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> rollback() {
        PromiseInternal promise = this.context.promise();
        TxCommand<Void> rollback = this.txCommand(TxCommand.Kind.ROLLBACK, (Promise<Void>)promise);
        TransactionImpl transactionImpl = this;
        synchronized (transactionImpl) {
            this.pending.addFirst(rollback);
        }
        this.checkPending();
        return promise.future();
    }

    @Override
    public void rollback(Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.rollback();
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    private TxCommand<Void> txCommand(TxCommand.Kind kind, Promise<Void> promise) {
        TxCommand<Object> cmd = new TxCommand<Object>(kind, null);
        cmd.handler = ar -> {
            this.tryComplete(kind);
            promise.handle(ar);
        };
        return cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryComplete(TxCommand.Kind kind) {
        TransactionImpl transactionImpl = this;
        synchronized (transactionImpl) {
            if (this.status == 3) {
                return;
            }
            this.status = 3;
        }
        switch (kind) {
            case COMMIT: {
                this.completion.complete();
                break;
            }
            case ROLLBACK: {
                this.completion.fail((Throwable)((Object)TransactionRollbackException.INSTANCE));
            }
        }
        this.checkPending();
    }

    @Override
    public void completion(Handler<AsyncResult<Void>> handler) {
        this.completion.future().onComplete(handler);
    }

    @Override
    public Future<Void> completion() {
        return this.completion.future();
    }
}

