/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.NoStackTraceThrowable;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.impl.NetSocketInternal;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.PreparedStatement;
import io.vertx.sqlclient.impl.cache.PreparedStatementCache;
import io.vertx.sqlclient.impl.codec.InvalidCachedStatementEvent;
import io.vertx.sqlclient.impl.command.CloseConnectionCommand;
import io.vertx.sqlclient.impl.command.CloseStatementCommand;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.command.CommandResponse;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;
import io.vertx.sqlclient.impl.command.PrepareStatementCommand;
import java.util.ArrayDeque;
import java.util.List;
import java.util.function.Predicate;

public abstract class SocketConnectionBase
implements Connection {
    protected static final Logger logger = LoggerFactory.getLogger(SocketConnectionBase.class);
    private static final String PENDING_CMD_CONNECTION_CORRUPT_MSG = "Pending requests failed to be sent due to connection has been closed.";
    protected final PreparedStatementCache psCache;
    private final Predicate<String> preparedStatementCacheSqlFilter;
    private final ContextInternal context;
    private Connection.Holder holder;
    private final int pipeliningLimit;
    private final ArrayDeque<CommandBase<?>> pending = new ArrayDeque();
    private boolean executing;
    private int inflight;
    private boolean paused;
    protected final NetSocketInternal socket;
    protected Status status = Status.CONNECTED;

    public SocketConnectionBase(NetSocketInternal socket, boolean cachePreparedStatements, int preparedStatementCacheSize, Predicate<String> preparedStatementCacheSqlFilter, int pipeliningLimit, ContextInternal context) {
        this.socket = socket;
        this.context = context;
        this.pipeliningLimit = pipeliningLimit;
        this.paused = false;
        this.psCache = cachePreparedStatements ? new PreparedStatementCache(preparedStatementCacheSize) : null;
        this.preparedStatementCacheSqlFilter = preparedStatementCacheSqlFilter;
    }

    public Context context() {
        return this.context;
    }

    public void init() {
        this.socket.closeHandler(this::handleClosed);
        this.socket.exceptionHandler(this::handleException);
        this.socket.messageHandler(msg -> {
            try {
                this.handleMessage(msg);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        });
    }

    public NetSocketInternal socket() {
        return this.socket;
    }

    @Override
    public boolean isSsl() {
        return this.socket.isSsl();
    }

    @Override
    public void init(Connection.Holder holder) {
        this.holder = holder;
    }

    @Override
    public int getProcessId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSecretKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close(Connection.Holder holder, Promise<Void> promise) {
        if (Vertx.currentContext() == this.context) {
            if (this.status == Status.CONNECTED) {
                this.status = Status.CLOSING;
                this.socket.channelHandlerContext().channel().closeFuture().addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> promise.complete()));
                this.pending.add(CloseConnectionCommand.INSTANCE);
                this.checkPending();
            }
        } else {
            this.context.runOnContext(v -> this.close(holder, promise));
        }
    }

    @Override
    public <R> void schedule(CommandBase<R> cmd, Promise<R> promise) {
        this.context.emit(v -> this.doSchedule(cmd, (Handler)promise));
    }

    protected <R> void doSchedule(CommandBase<R> cmd, Handler<AsyncResult<R>> handler) {
        if (handler == null) {
            throw new IllegalArgumentException();
        }
        Context context = Vertx.currentContext();
        if (context != this.context) {
            throw new IllegalStateException();
        }
        cmd.handler = handler;
        if (this.status == Status.CONNECTED) {
            this.pending.add(cmd);
            this.checkPending();
        } else {
            cmd.fail((Throwable)new VertxException("Connection not open " + (Object)((Object)this.status)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPending() {
        if (this.executing) {
            return;
        }
        try {
            PrepareStatementCommand cmd;
            this.executing = true;
            ChannelHandlerContext ctx = this.socket.channelHandlerContext();
            int written = 0;
            while (!this.paused && this.inflight < this.pipeliningLimit && (cmd = this.pending.poll()) != null) {
                ++this.inflight;
                if (cmd instanceof ExtendedQueryCommand) {
                    ExtendedQueryCommand queryCmd = (ExtendedQueryCommand)((Object)cmd);
                    if (queryCmd.ps == null && this.psCache != null) {
                        queryCmd.ps = this.psCache.get(queryCmd.sql());
                    }
                    if (queryCmd.ps == null) {
                        CloseStatementCommand closeCmd;
                        boolean cache;
                        boolean bl = cache = this.psCache != null && this.preparedStatementCacheSqlFilter.test(queryCmd.sql());
                        if (cache && (closeCmd = this.evictStatementIfNecessary()) != null) {
                            ++this.inflight;
                            ++written;
                            ctx.write((Object)closeCmd);
                        }
                        PrepareStatementCommand prepareCmd = this.prepareCommand(queryCmd, cache, false);
                        this.paused = true;
                        ++this.inflight;
                        cmd = prepareCmd;
                    } else {
                        String msg = queryCmd.prepare();
                        if (msg != null) {
                            --this.inflight;
                            queryCmd.fail((Throwable)new NoStackTraceThrowable(msg));
                            continue;
                        }
                    }
                }
                ++written;
                ctx.write(cmd);
            }
            if (written > 0) {
                ctx.flush();
            }
        }
        finally {
            this.executing = false;
        }
    }

    private PrepareStatementCommand prepareCommand(ExtendedQueryCommand<?> queryCmd, boolean cache, boolean sendParameterTypes) {
        PrepareStatementCommand prepareCmd = new PrepareStatementCommand(queryCmd.sql(), cache, sendParameterTypes ? queryCmd.parameterTypes() : null);
        prepareCmd.handler = ar -> {
            this.paused = false;
            if (ar.succeeded()) {
                PreparedStatement ps = (PreparedStatement)ar.result();
                if (cache) {
                    this.cacheStatement(ps);
                }
                queryCmd.ps = ps;
                String msg = queryCmd.prepare();
                if (msg != null) {
                    --this.inflight;
                    queryCmd.fail((Throwable)new NoStackTraceThrowable(msg));
                } else {
                    ChannelHandlerContext ctx = this.socket.channelHandlerContext();
                    ctx.write((Object)queryCmd);
                    ctx.flush();
                }
            } else {
                Throwable cause = ar.cause();
                if (this.isIndeterminatePreparedStatementError(cause) && !sendParameterTypes) {
                    ChannelHandlerContext ctx = this.socket.channelHandlerContext();
                    ctx.write((Object)this.prepareCommand(queryCmd, false, true));
                    ctx.flush();
                } else {
                    --this.inflight;
                    queryCmd.fail(cause);
                }
            }
        };
        return prepareCmd;
    }

    protected void handleMessage(Object msg) {
        if (msg instanceof CommandResponse) {
            --this.inflight;
            CommandResponse resp = (CommandResponse)msg;
            resp.fire();
            this.checkPending();
        } else if (msg instanceof InvalidCachedStatementEvent) {
            InvalidCachedStatementEvent event = (InvalidCachedStatementEvent)msg;
            this.removeCachedStatement(event.sql());
        }
    }

    protected void handleEvent(Object event) {
        if (this.holder != null) {
            this.holder.handleEvent(event);
        }
    }

    private CloseStatementCommand evictStatementIfNecessary() {
        if (this.psCache != null && this.psCache.isFull()) {
            PreparedStatement evicted = this.psCache.evict();
            CloseStatementCommand closeCmd = new CloseStatementCommand(evicted);
            closeCmd.handler = ar -> {
                if (ar.failed()) {
                    logger.error((Object)"Error when closing cached prepared statement", ar.cause());
                }
            };
            return closeCmd;
        }
        return null;
    }

    private void cacheStatement(PreparedStatement preparedStatement) {
        if (this.psCache != null) {
            List<PreparedStatement> evictedList = this.psCache.put(preparedStatement);
            assert (evictedList.size() == 0);
        }
    }

    private void removeCachedStatement(String sql) {
        if (this.psCache != null) {
            this.psCache.remove(sql);
        }
    }

    private void handleClosed(Void v) {
        this.handleClose(null);
    }

    private synchronized void handleException(Throwable t) {
        if (t instanceof DecoderException) {
            DecoderException err = (DecoderException)t;
            t = err.getCause();
        }
        this.handleClose(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleClose(Throwable t) {
        if (this.status != Status.CLOSED) {
            CommandBase<?> cmd;
            NoStackTraceThrowable cause;
            this.status = Status.CLOSED;
            if (t != null) {
                SocketConnectionBase socketConnectionBase = this;
                synchronized (socketConnectionBase) {
                    if (this.holder != null) {
                        this.holder.handleException(t);
                    }
                }
            }
            Object object = cause = t == null ? new NoStackTraceThrowable(PENDING_CMD_CONNECTION_CORRUPT_MSG) : new VertxException(PENDING_CMD_CONNECTION_CORRUPT_MSG, t);
            while ((cmd = this.pending.poll()) != null) {
                CommandBase<?> c = cmd;
                this.context.runOnContext(arg_0 -> SocketConnectionBase.lambda$handleClose$6(c, (Throwable)cause, arg_0));
            }
            if (this.holder != null) {
                this.holder.handleClosed();
            }
        }
    }

    private static /* synthetic */ void lambda$handleClose$6(CommandBase c, Throwable cause, Void v) {
        c.fail(cause);
    }

    public static enum Status {
        CLOSED,
        CONNECTED,
        CLOSING;

    }
}

