/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.core.Future;
import io.vertx.mysqlclient.impl.codec.MySQLEncoder;
import io.vertx.mysqlclient.impl.codec.QueryCommandBaseCodec;
import io.vertx.mysqlclient.impl.datatype.DataFormat;
import io.vertx.mysqlclient.impl.protocol.Packets;
import io.vertx.sqlclient.impl.command.SimpleQueryCommand;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.function.Supplier;

class SimpleQueryCommandCodec<T>
extends QueryCommandBaseCodec<T, SimpleQueryCommand<T>> {
    SimpleQueryCommandCodec(SimpleQueryCommand<T> cmd) {
        super(cmd, DataFormat.TEXT);
    }

    @Override
    void encode(MySQLEncoder encoder) {
        super.encode(encoder);
        this.sendQueryCommand();
    }

    @Override
    protected void handleInitPacket(ByteBuf payload) {
        short firstByte = payload.getUnsignedByte(payload.readerIndex());
        if (firstByte == 0) {
            Packets.OkPacket okPacket = this.decodeOkPacketPayload(payload);
            this.handleSingleResultsetDecodingCompleted(okPacket.serverStatusFlags(), okPacket.affectedRows(), okPacket.lastInsertId());
        } else if (firstByte == 255) {
            this.handleErrorPacketPayload(payload);
        } else if (firstByte == 251) {
            this.handleLocalInfile(payload);
        } else {
            this.handleResultsetColumnCountPacketBody(payload);
        }
    }

    private void sendQueryCommand() {
        ByteBuf packet = this.allocateBuffer();
        int packetStartIdx = packet.writerIndex();
        packet.writeMediumLE(0);
        packet.writeByte(this.sequenceId);
        packet.writeByte(3);
        packet.writeCharSequence((CharSequence)((SimpleQueryCommand)this.cmd).sql(), this.encoder.encodingCharset);
        int payloadLength = packet.writerIndex() - packetStartIdx - 4;
        packet.setMediumLE(packetStartIdx, payloadLength);
        this.sendPacket(packet, payloadLength);
    }

    private void handleLocalInfile(ByteBuf payload) {
        payload.skipBytes(1);
        String filename = this.readRestOfPacketString(payload, StandardCharsets.UTF_8);
        File file = new File(filename);
        long fileLength = file.length();
        ArrayList<Supplier<Future>> sendingFileInPacketContList = new ArrayList<Supplier<Future>>();
        int offset = 0;
        int remainingLen = (int)fileLength;
        while (remainingLen >= 0xFFFFFF) {
            int currentOffset = offset;
            sendingFileInPacketContList.add(() -> this.sendFileInPacket(filename, currentOffset, 0xFFFFFF));
            remainingLen -= 0xFFFFFF;
            offset += 0xFFFFFF;
        }
        int tailLength = remainingLen;
        int tailOffset = offset;
        Future cont = Future.succeededFuture();
        for (Supplier supplier : sendingFileInPacketContList) {
            cont = cont.flatMap(arg_0 -> SimpleQueryCommandCodec.lambda$handleLocalInfile$1((Supplier)supplier, arg_0));
        }
        if (tailLength > 0) {
            cont = cont.flatMap(v -> this.sendFileInPacket(filename, tailOffset, tailLength));
        }
        cont.onComplete(v -> this.sendEmptyPacket());
    }

    private Future<Void> sendFileInPacket(String filename, int offset, int length) {
        ByteBuf packetHeader = this.allocateBuffer(4);
        packetHeader.writeMediumLE(length);
        packetHeader.writeByte(this.sequenceId++);
        this.encoder.chctx.write((Object)packetHeader);
        return this.encoder.socketConnection.socket().sendFile(filename, (long)offset, (long)length);
    }

    private void sendEmptyPacket() {
        ByteBuf packet = this.allocateBuffer(4);
        packet.writeMediumLE(0);
        packet.writeByte(this.sequenceId);
        this.sendNonSplitPacket(packet);
    }

    private static /* synthetic */ Future lambda$handleLocalInfile$1(Supplier futureSupplier, Void v) {
        return (Future)futureSupplier.get();
    }
}

