/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.net.impl.NetSocketInternal;
import io.vertx.mysqlclient.MySQLAuthenticationPlugin;
import io.vertx.mysqlclient.SslMode;
import io.vertx.mysqlclient.impl.MySQLCollation;
import io.vertx.mysqlclient.impl.MySQLDatabaseMetadata;
import io.vertx.mysqlclient.impl.codec.MySQLCodec;
import io.vertx.mysqlclient.impl.command.InitialHandshakeCommand;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.QueryResultHandler;
import io.vertx.sqlclient.impl.SocketConnectionBase;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.command.QueryCommandBase;
import io.vertx.sqlclient.impl.command.SimpleQueryCommand;
import io.vertx.sqlclient.impl.command.TxCommand;
import io.vertx.sqlclient.spi.DatabaseMetadata;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.function.Predicate;

public class MySQLSocketConnection
extends SocketConnectionBase {
    public MySQLDatabaseMetadata metaData;
    private MySQLCodec codec;

    public MySQLSocketConnection(NetSocketInternal socket, boolean cachePreparedStatements, int preparedStatementCacheSize, Predicate<String> preparedStatementCacheSqlFilter, ContextInternal context) {
        super(socket, cachePreparedStatements, preparedStatementCacheSize, preparedStatementCacheSqlFilter, 1, context);
    }

    void sendStartupMessage(String username, String password, String database, MySQLCollation collation, Buffer serverRsaPublicKey, Map<String, String> properties, SslMode sslMode, int initialCapabilitiesFlags, Charset charsetEncoding, MySQLAuthenticationPlugin authenticationPlugin, Promise<Connection> completionHandler) {
        InitialHandshakeCommand cmd = new InitialHandshakeCommand(this, username, password, database, collation, serverRsaPublicKey, properties, sslMode, initialCapabilitiesFlags, charsetEncoding, authenticationPlugin);
        this.schedule(cmd, completionHandler);
    }

    public void init() {
        this.codec = new MySQLCodec(this);
        ChannelPipeline pipeline = this.socket.channelHandlerContext().pipeline();
        pipeline.addBefore("handler", "codec", (ChannelHandler)this.codec);
        super.init();
    }

    protected <R> void doSchedule(CommandBase<R> cmd, Handler<AsyncResult<R>> handler) {
        if (cmd instanceof TxCommand) {
            TxCommand tx = (TxCommand)cmd;
            SimpleQueryCommand cmd2 = new SimpleQueryCommand(tx.kind.sql, false, false, QueryCommandBase.NULL_COLLECTOR, QueryResultHandler.NOOP_HANDLER);
            super.doSchedule((CommandBase)cmd2, ar -> handler.handle((Object)ar.map(tx.result)));
        } else {
            super.doSchedule(cmd, handler);
        }
    }

    public void upgradeToSsl(Handler<AsyncResult<Void>> completionHandler) {
        this.socket.upgradeToSsl(completionHandler);
    }

    public DatabaseMetadata getDatabaseMetaData() {
        return this.metaData;
    }
}

