/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Handler;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.MySQLPool;
import io.vertx.mysqlclient.impl.MySQLConnectionFactory;
import io.vertx.mysqlclient.impl.MySQLConnectionImpl;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.ConnectionFactory;
import io.vertx.sqlclient.impl.PoolBase;
import io.vertx.sqlclient.impl.SqlConnectionImpl;
import io.vertx.sqlclient.impl.tracing.QueryTracer;

public class MySQLPoolImpl
extends PoolBase<MySQLPoolImpl>
implements MySQLPool {
    private final MySQLConnectionFactory factory;

    public static MySQLPoolImpl create(ContextInternal context, boolean closeVertx, MySQLConnectOptions connectOptions, PoolOptions poolOptions) {
        QueryTracer tracer = context.tracer() == null ? null : new QueryTracer(context.tracer(), (SqlConnectOptions)connectOptions);
        VertxMetrics vertxMetrics = context.owner().metricsSPI();
        ClientMetrics metrics = vertxMetrics != null ? vertxMetrics.createClientMetrics(connectOptions.getSocketAddress(), "sql", connectOptions.getMetricsName()) : null;
        MySQLPoolImpl pool = new MySQLPoolImpl(context, new MySQLConnectionFactory(context, connectOptions), tracer, metrics, poolOptions);
        CloseFuture closeFuture = pool.closeFuture();
        if (closeVertx) {
            closeFuture.onComplete(ar -> context.owner().close());
        } else {
            context.addCloseHook((Closeable)closeFuture);
        }
        return pool;
    }

    private MySQLPoolImpl(ContextInternal context, MySQLConnectionFactory factory, QueryTracer tracer, ClientMetrics metrics, PoolOptions poolOptions) {
        super(context, (ConnectionFactory)factory, tracer, metrics, poolOptions);
        this.factory = factory;
    }

    public void connect(Handler<AsyncResult<Connection>> completionHandler) {
        this.factory.connect().onComplete(completionHandler);
    }

    protected SqlConnectionImpl wrap(ContextInternal context, Connection conn) {
        return new MySQLConnectionImpl(this.factory, context, conn, this.tracer, this.metrics);
    }
}

