/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl;

import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.sqlclient.spi.DatabaseMetadata;

public class MySQLDatabaseMetadata
implements DatabaseMetadata {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySQLDatabaseMetadata.class);
    private final String fullVersion;
    private final String productName;
    private final int majorVersion;
    private final int minorVersion;
    private final int microVersion;

    private MySQLDatabaseMetadata(String fullVersion, String productName, int majorVersion, int minorVersion, int microVersion) {
        this.fullVersion = fullVersion;
        this.productName = productName;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.microVersion = microVersion;
    }

    public static MySQLDatabaseMetadata parse(String serverVersion) {
        int versionTokenStartIdx;
        int majorVersion = 0;
        int minorVersion = 0;
        int microVersion = 0;
        int len = serverVersion.length();
        boolean isMariaDb = serverVersion.contains("MariaDB");
        String productName = isMariaDb ? "MariaDB" : "MySQL";
        String versionToken = null;
        for (int versionTokenEndIdx = versionTokenStartIdx = isMariaDb ? 6 : 0; versionTokenEndIdx < len; ++versionTokenEndIdx) {
            if (serverVersion.charAt(versionTokenEndIdx) != '-') continue;
            versionToken = serverVersion.substring(versionTokenStartIdx, versionTokenEndIdx);
            break;
        }
        if (versionToken == null) {
            versionToken = serverVersion;
        }
        String[] versionTokens = versionToken.split("\\.");
        try {
            majorVersion = Integer.parseInt(versionTokens[0]);
            minorVersion = Integer.parseInt(versionTokens[1]);
            microVersion = Integer.parseInt(versionTokens[2]);
        }
        catch (Exception ex) {
            LOGGER.warn((Object)"Incorrect parsing server version tokens", (Throwable)ex);
        }
        return new MySQLDatabaseMetadata(serverVersion, productName, majorVersion, minorVersion, microVersion);
    }

    public String productName() {
        return this.productName;
    }

    public String fullVersion() {
        return this.fullVersion;
    }

    public int majorVersion() {
        return this.majorVersion;
    }

    public int minorVersion() {
        return this.minorVersion;
    }

    public int microVersion() {
        return this.microVersion;
    }
}

