/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt;

import io.netty.handler.codec.mqtt.MqttQoS;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.mqtt.MqttClientOptions;
import io.vertx.mqtt.impl.MqttClientImpl;
import io.vertx.mqtt.messages.MqttConnAckMessage;
import io.vertx.mqtt.messages.MqttPublishMessage;
import io.vertx.mqtt.messages.MqttSubAckMessage;
import java.util.List;
import java.util.Map;

@VertxGen
public interface MqttClient {
    public static MqttClient create(Vertx vertx, MqttClientOptions options) {
        return new MqttClientImpl(vertx, options);
    }

    public static MqttClient create(Vertx vertx) {
        return new MqttClientImpl(vertx, new MqttClientOptions());
    }

    @Fluent
    public MqttClient connect(int var1, String var2, Handler<AsyncResult<MqttConnAckMessage>> var3);

    public Future<MqttConnAckMessage> connect(int var1, String var2);

    @Fluent
    public MqttClient connect(int var1, String var2, String var3, Handler<AsyncResult<MqttConnAckMessage>> var4);

    public Future<MqttConnAckMessage> connect(int var1, String var2, String var3);

    public Future<Void> disconnect();

    @Fluent
    public MqttClient disconnect(Handler<AsyncResult<Void>> var1);

    public Future<Integer> publish(String var1, Buffer var2, MqttQoS var3, boolean var4, boolean var5);

    @Fluent
    public MqttClient publish(String var1, Buffer var2, MqttQoS var3, boolean var4, boolean var5, Handler<AsyncResult<Integer>> var6);

    @Fluent
    public MqttClient publishCompletionHandler(Handler<Integer> var1);

    @Fluent
    public MqttClient publishCompletionExpirationHandler(Handler<Integer> var1);

    @Fluent
    public MqttClient publishCompletionUnknownPacketIdHandler(Handler<Integer> var1);

    @Fluent
    public MqttClient publishHandler(Handler<MqttPublishMessage> var1);

    @Fluent
    public MqttClient subscribeCompletionHandler(Handler<MqttSubAckMessage> var1);

    public Future<Integer> subscribe(String var1, int var2);

    @Fluent
    public MqttClient subscribe(String var1, int var2, Handler<AsyncResult<Integer>> var3);

    public Future<Integer> subscribe(Map<String, Integer> var1);

    @Fluent
    public MqttClient subscribe(Map<String, Integer> var1, Handler<AsyncResult<Integer>> var2);

    @Fluent
    public MqttClient unsubscribeCompletionHandler(Handler<Integer> var1);

    public Future<Integer> unsubscribe(String var1);

    public Future<Integer> unsubscribe(List<String> var1);

    @Fluent
    public MqttClient unsubscribe(List<String> var1, Handler<AsyncResult<Integer>> var2);

    @Fluent
    public MqttClient unsubscribe(String var1, Handler<AsyncResult<Integer>> var2);

    @Fluent
    public MqttClient pingResponseHandler(Handler<Void> var1);

    @Fluent
    public MqttClient exceptionHandler(Handler<Throwable> var1);

    @Fluent
    public MqttClient closeHandler(Handler<Void> var1);

    @Fluent
    public MqttClient ping();

    public String clientId();

    public boolean isConnected();
}

