/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.util.ConcurrentDirectDeque;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class PortableConcurrentDirectDeque<E>
extends ConcurrentDirectDeque<E>
implements Deque<E>,
Serializable {
    private static final long serialVersionUID = 876323262645176354L;
    private volatile transient Node<E> head;
    private volatile transient Node<E> tail;
    private static final AtomicReferenceFieldUpdater<PortableConcurrentDirectDeque, Node> headUpdater = AtomicReferenceFieldUpdater.newUpdater(PortableConcurrentDirectDeque.class, Node.class, "head");
    private static final AtomicReferenceFieldUpdater<PortableConcurrentDirectDeque, Node> tailUpdater = AtomicReferenceFieldUpdater.newUpdater(PortableConcurrentDirectDeque.class, Node.class, "tail");
    private static final Node<Object> PREV_TERMINATOR = new Node();
    private static final Node<Object> NEXT_TERMINATOR;
    private static final int HOPS = 2;

    Node<E> prevTerminator() {
        return PREV_TERMINATOR;
    }

    Node<E> nextTerminator() {
        return NEXT_TERMINATOR;
    }

    private Node linkFirst(E e) {
        Node p;
        Node h;
        PortableConcurrentDirectDeque.checkNotNull(e);
        Node newNode = new Node(e);
        block0: while (true) {
            p = h = this.head;
            while (true) {
                Node q;
                if ((q = p.prev) != null) {
                    p = q;
                    q = p.prev;
                    if (q != null) {
                        p = h != (h = this.head) ? h : q;
                        continue;
                    }
                }
                if (p.next == p) continue block0;
                newNode.lazySetNext(p);
                if (p.casPrev(null, newNode)) break block0;
            }
            break;
        }
        if (p != h) {
            this.casHead(h, newNode);
        }
        return newNode;
    }

    private Node linkLast(E e) {
        Node p;
        Node t;
        PortableConcurrentDirectDeque.checkNotNull(e);
        Node newNode = new Node(e);
        block0: while (true) {
            p = t = this.tail;
            while (true) {
                Node q;
                if ((q = p.next) != null) {
                    p = q;
                    q = p.next;
                    if (q != null) {
                        p = t != (t = this.tail) ? t : q;
                        continue;
                    }
                }
                if (p.prev == p) continue block0;
                newNode.lazySetPrev(p);
                if (p.casNext(null, newNode)) break block0;
            }
            break;
        }
        if (p != t) {
            this.casTail(t, newNode);
        }
        return newNode;
    }

    void unlink(Node<E> x) {
        Node prev = x.prev;
        Node next = x.next;
        if (prev == null) {
            this.unlinkFirst(x, next);
        } else if (next == null) {
            this.unlinkLast(x, prev);
        } else {
            boolean isLast;
            Node activeSucc;
            Node q;
            boolean isFirst;
            Node activePred;
            int hops = 1;
            Node p = prev;
            while (true) {
                if (p.item != null) {
                    activePred = p;
                    isFirst = false;
                    break;
                }
                q = p.prev;
                if (q == null) {
                    if (p.next == p) {
                        return;
                    }
                    activePred = p;
                    isFirst = true;
                    break;
                }
                if (p == q) {
                    return;
                }
                p = q;
                ++hops;
            }
            p = next;
            while (true) {
                if (p.item != null) {
                    activeSucc = p;
                    isLast = false;
                    break;
                }
                q = p.next;
                if (q == null) {
                    if (p.prev == p) {
                        return;
                    }
                    activeSucc = p;
                    isLast = true;
                    break;
                }
                if (p == q) {
                    return;
                }
                p = q;
                ++hops;
            }
            if (hops < 2 && isFirst | isLast) {
                return;
            }
            this.skipDeletedSuccessors(activePred);
            this.skipDeletedPredecessors(activeSucc);
            if (isFirst | isLast && activePred.next == activeSucc && activeSucc.prev == activePred && (isFirst ? activePred.prev == null : activePred.item != null) && (isLast ? activeSucc.next == null : activeSucc.item != null)) {
                this.updateHead();
                this.updateTail();
                x.lazySetPrev(isFirst ? this.prevTerminator() : x);
                x.lazySetNext(isLast ? this.nextTerminator() : x);
            }
        }
    }

    private void unlinkFirst(Node<E> first, Node<E> next) {
        Node<E> o = null;
        Node<E> p = next;
        while (true) {
            Node q;
            if (p.item != null || (q = p.next) == null) {
                if (o != null && p.prev != p && first.casNext(next, p)) {
                    this.skipDeletedPredecessors(p);
                    if (first.prev == null && (p.next == null || p.item != null) && p.prev == first) {
                        this.updateHead();
                        this.updateTail();
                        o.lazySetNext(o);
                        o.lazySetPrev(this.prevTerminator());
                    }
                }
                return;
            }
            if (p == q) {
                return;
            }
            o = p;
            p = q;
        }
    }

    private void unlinkLast(Node<E> last, Node<E> prev) {
        Node<E> o = null;
        Node<E> p = prev;
        while (true) {
            Node q;
            if (p.item != null || (q = p.prev) == null) {
                if (o != null && p.next != p && last.casPrev(prev, p)) {
                    this.skipDeletedSuccessors(p);
                    if (last.next == null && (p.prev == null || p.item != null) && p.next == last) {
                        this.updateHead();
                        this.updateTail();
                        o.lazySetPrev(o);
                        o.lazySetNext(this.nextTerminator());
                    }
                }
                return;
            }
            if (p == q) {
                return;
            }
            o = p;
            p = q;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void updateHead() {
        block0: while (true) {
            h = this.head;
            if (h.item != null || (p = h.prev) == null) break;
            while (true) {
                block5: {
                    block4: {
                        if ((q = p.prev) == null) break block4;
                        p = q;
                        q = p.prev;
                        if (q != null) break block5;
                    }
                    if (!this.casHead(h, p)) continue block0;
                    return;
                }
                if (h == this.head) ** break;
                continue block0;
                p = q;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void updateTail() {
        block0: while (true) {
            t = this.tail;
            if (t.item != null || (p = t.next) == null) break;
            while (true) {
                block5: {
                    block4: {
                        if ((q = p.next) == null) break block4;
                        p = q;
                        q = p.next;
                        if (q != null) break block5;
                    }
                    if (!this.casTail(t, p)) continue block0;
                    return;
                }
                if (t == this.tail) ** break;
                continue block0;
                p = q;
            }
            break;
        }
    }

    private void skipDeletedPredecessors(Node<E> x) {
        block0: do {
            Node prev;
            Node p = prev = x.prev;
            while (p.item == null) {
                Node q = p.prev;
                if (q == null) {
                    if (p.next != p) break;
                    continue block0;
                }
                if (p == q) continue block0;
                p = q;
            }
            if (prev != p && !x.casPrev(prev, p)) continue;
            return;
        } while (x.item != null || x.next == null);
    }

    private void skipDeletedSuccessors(Node<E> x) {
        block0: do {
            Node next;
            Node p = next = x.next;
            while (p.item == null) {
                Node q = p.next;
                if (q == null) {
                    if (p.prev != p) break;
                    continue block0;
                }
                if (p == q) continue block0;
                p = q;
            }
            if (next != p && !x.casNext(next, p)) continue;
            return;
        } while (x.item != null || x.prev == null);
    }

    final Node<E> succ(Node<E> p) {
        Node q = p.next;
        return p == q ? this.first() : q;
    }

    final Node<E> pred(Node<E> p) {
        Node q = p.prev;
        return p == q ? this.last() : q;
    }

    Node<E> first() {
        Node<E> h;
        Node<E> p;
        block0: do {
            Node q;
            p = h = this.head;
            while ((q = p.prev) != null) {
                p = q;
                q = p.prev;
                if (q == null) continue block0;
                p = h != (h = this.head) ? h : q;
            }
        } while (p != h && !this.casHead(h, p));
        return p;
    }

    Node<E> last() {
        Node<E> t;
        Node<E> p;
        block0: do {
            Node q;
            p = t = this.tail;
            while ((q = p.next) != null) {
                p = q;
                q = p.next;
                if (q == null) continue block0;
                p = t != (t = this.tail) ? t : q;
            }
        } while (p != t && !this.casTail(t, p));
        return p;
    }

    private static void checkNotNull(Object v) {
        if (v == null) {
            throw new NullPointerException();
        }
    }

    private E screenNullResult(E v) {
        if (v == null) {
            throw new NoSuchElementException();
        }
        return v;
    }

    private ArrayList<E> toArrayList() {
        ArrayList list = new ArrayList();
        Node<E> p = this.first();
        while (p != null) {
            Object item = p.item;
            if (item != null) {
                list.add(item);
            }
            p = this.succ(p);
        }
        return list;
    }

    public PortableConcurrentDirectDeque() {
        this.tail = new Node<Object>(null);
        this.head = this.tail;
    }

    public PortableConcurrentDirectDeque(Collection<? extends E> c) {
        Node<E> h = null;
        Node<E> t = null;
        for (E e : c) {
            PortableConcurrentDirectDeque.checkNotNull(e);
            Node<E> newNode = new Node<E>(e);
            if (h == null) {
                h = t = newNode;
                continue;
            }
            t.lazySetNext(newNode);
            newNode.lazySetPrev(t);
            t = newNode;
        }
        this.initHeadTail(h, t);
    }

    private void initHeadTail(Node<E> h, Node<E> t) {
        if (h == t) {
            if (h == null) {
                t = new Node<Object>(null);
                h = t;
            } else {
                Node<Object> newNode = new Node<Object>(null);
                t.lazySetNext(newNode);
                newNode.lazySetPrev(t);
                t = newNode;
            }
        }
        this.head = h;
        this.tail = t;
    }

    @Override
    public void addFirst(E e) {
        this.linkFirst(e);
    }

    @Override
    public void addLast(E e) {
        this.linkLast(e);
    }

    @Override
    public boolean offerFirst(E e) {
        this.linkFirst(e);
        return true;
    }

    @Override
    public Object offerFirstAndReturnToken(E e) {
        return this.linkFirst(e);
    }

    @Override
    public Object offerLastAndReturnToken(E e) {
        return this.linkLast(e);
    }

    @Override
    public void removeToken(Object token) {
        if (!(token instanceof Node)) {
            throw new IllegalArgumentException();
        }
        Node node = (Node)token;
        while (!node.casItem(node.item, null)) {
        }
        this.unlink(node);
    }

    @Override
    public boolean offerLast(E e) {
        this.linkLast(e);
        return true;
    }

    @Override
    public E peekFirst() {
        Node<E> p = this.first();
        while (p != null) {
            Object item = p.item;
            if (item != null) {
                return item;
            }
            p = this.succ(p);
        }
        return null;
    }

    @Override
    public E peekLast() {
        Node<E> p = this.last();
        while (p != null) {
            Object item = p.item;
            if (item != null) {
                return item;
            }
            p = this.pred(p);
        }
        return null;
    }

    @Override
    public E getFirst() {
        return this.screenNullResult(this.peekFirst());
    }

    @Override
    public E getLast() {
        return this.screenNullResult(this.peekLast());
    }

    @Override
    public E pollFirst() {
        Node<Object> p = this.first();
        while (p != null) {
            Object item = p.item;
            if (item != null && p.casItem(item, null)) {
                this.unlink(p);
                return item;
            }
            p = this.succ(p);
        }
        return null;
    }

    @Override
    public E pollLast() {
        Node<Object> p = this.last();
        while (p != null) {
            Object item = p.item;
            if (item != null && p.casItem(item, null)) {
                this.unlink(p);
                return item;
            }
            p = this.pred(p);
        }
        return null;
    }

    @Override
    public E removeFirst() {
        return this.screenNullResult(this.pollFirst());
    }

    @Override
    public E removeLast() {
        return this.screenNullResult(this.pollLast());
    }

    @Override
    public boolean offer(E e) {
        return this.offerLast(e);
    }

    @Override
    public boolean add(E e) {
        return this.offerLast(e);
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        PortableConcurrentDirectDeque.checkNotNull(o);
        Node<Object> p = this.first();
        while (p != null) {
            Object item = p.item;
            if (item != null && o.equals(item) && p.casItem(item, null)) {
                this.unlink(p);
                return true;
            }
            p = this.succ(p);
        }
        return false;
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        PortableConcurrentDirectDeque.checkNotNull(o);
        Node<Object> p = this.last();
        while (p != null) {
            Object item = p.item;
            if (item != null && o.equals(item) && p.casItem(item, null)) {
                this.unlink(p);
                return true;
            }
            p = this.pred(p);
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        Node<E> p = this.first();
        while (p != null) {
            Object item = p.item;
            if (item != null && o.equals(item)) {
                return true;
            }
            p = this.succ(p);
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.peekFirst() == null;
    }

    @Override
    public int size() {
        int count = 0;
        Node<E> p = this.first();
        while (p != null && (p.item == null || ++count != Integer.MAX_VALUE)) {
            p = this.succ(p);
        }
        return count;
    }

    @Override
    public boolean remove(Object o) {
        return this.removeFirstOccurrence(o);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Node t;
        if (c == this) {
            throw new IllegalArgumentException();
        }
        Node beginningOfTheEnd = null;
        Node last = null;
        for (E e : c) {
            PortableConcurrentDirectDeque.checkNotNull(e);
            Node newNode = new Node(e);
            if (beginningOfTheEnd == null) {
                beginningOfTheEnd = last = newNode;
                continue;
            }
            last.lazySetNext(newNode);
            newNode.lazySetPrev(last);
            last = newNode;
        }
        if (beginningOfTheEnd == null) {
            return false;
        }
        block1: while (true) {
            Node p = t = this.tail;
            while (true) {
                Node q;
                if ((q = p.next) != null) {
                    p = q;
                    q = p.next;
                    if (q != null) {
                        p = t != (t = this.tail) ? t : q;
                        continue;
                    }
                }
                if (p.prev == p) continue block1;
                beginningOfTheEnd.lazySetPrev(p);
                if (p.casNext(null, beginningOfTheEnd)) break block1;
            }
            break;
        }
        if (!this.casTail(t, last)) {
            t = this.tail;
            if (last.next == null) {
                this.casTail(t, last);
            }
        }
        return true;
    }

    @Override
    public void clear() {
        while (this.pollFirst() != null) {
        }
    }

    @Override
    public Object[] toArray() {
        return this.toArrayList().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.toArrayList().toArray(a);
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new DescendingItr();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Node<E> p = this.first();
        while (p != null) {
            Object item = p.item;
            if (item != null) {
                s.writeObject(item);
            }
            p = this.succ(p);
        }
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        Object item;
        s.defaultReadObject();
        Node<Object> h = null;
        Node<Object> t = null;
        while ((item = s.readObject()) != null) {
            Node<Object> newNode = new Node<Object>(item);
            if (h == null) {
                h = t = newNode;
                continue;
            }
            t.lazySetNext(newNode);
            newNode.lazySetPrev(t);
            t = newNode;
        }
        this.initHeadTail(h, t);
    }

    private boolean casHead(Node<E> cmp, Node<E> val) {
        return headUpdater.compareAndSet(this, cmp, val);
    }

    private boolean casTail(Node<E> cmp, Node<E> val) {
        return tailUpdater.compareAndSet(this, cmp, val);
    }

    static {
        PortableConcurrentDirectDeque.PREV_TERMINATOR.next = PREV_TERMINATOR;
        NEXT_TERMINATOR = new Node();
        PortableConcurrentDirectDeque.NEXT_TERMINATOR.prev = NEXT_TERMINATOR;
    }

    private class DescendingItr
    extends AbstractItr {
        private DescendingItr() {
        }

        @Override
        Node<E> startNode() {
            return PortableConcurrentDirectDeque.this.last();
        }

        @Override
        Node<E> nextNode(Node<E> p) {
            return PortableConcurrentDirectDeque.this.pred(p);
        }
    }

    private class Itr
    extends AbstractItr {
        private Itr() {
        }

        @Override
        Node<E> startNode() {
            return PortableConcurrentDirectDeque.this.first();
        }

        @Override
        Node<E> nextNode(Node<E> p) {
            return PortableConcurrentDirectDeque.this.succ(p);
        }
    }

    private abstract class AbstractItr
    implements Iterator<E> {
        private Node<E> nextNode;
        private E nextItem;
        private Node<E> lastRet;

        abstract Node<E> startNode();

        abstract Node<E> nextNode(Node<E> var1);

        AbstractItr() {
            this.advance();
        }

        private void advance() {
            Node p;
            this.lastRet = this.nextNode;
            Node node = p = this.nextNode == null ? this.startNode() : this.nextNode(this.nextNode);
            while (true) {
                if (p == null) {
                    this.nextNode = null;
                    this.nextItem = null;
                    break;
                }
                Object item = p.item;
                if (item != null) {
                    this.nextNode = p;
                    this.nextItem = item;
                    break;
                }
                p = this.nextNode(p);
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextItem != null;
        }

        @Override
        public E next() {
            Object item = this.nextItem;
            if (item == null) {
                throw new NoSuchElementException();
            }
            this.advance();
            return item;
        }

        @Override
        public void remove() {
            Node l = this.lastRet;
            if (l == null) {
                throw new IllegalStateException();
            }
            l.item = null;
            PortableConcurrentDirectDeque.this.unlink(l);
            this.lastRet = null;
        }
    }

    static final class Node<E> {
        private static final AtomicReferenceFieldUpdater<Node, Node> prevUpdater = AtomicReferenceFieldUpdater.newUpdater(Node.class, Node.class, "prev");
        private static final AtomicReferenceFieldUpdater<Node, Node> nextUpdater = AtomicReferenceFieldUpdater.newUpdater(Node.class, Node.class, "next");
        private static final AtomicReferenceFieldUpdater<Node, Object> itemUpdater = AtomicReferenceFieldUpdater.newUpdater(Node.class, Object.class, "item");
        volatile Node<E> prev;
        volatile E item;
        volatile Node<E> next;

        Node() {
        }

        Node(E item) {
            this.item = item;
        }

        boolean casItem(E cmp, E val) {
            return itemUpdater.compareAndSet(this, cmp, val);
        }

        void lazySetNext(Node<E> val) {
            this.next = val;
        }

        boolean casNext(Node<E> cmp, Node<E> val) {
            return nextUpdater.compareAndSet(this, cmp, val);
        }

        void lazySetPrev(Node<E> val) {
            this.prev = val;
        }

        boolean casPrev(Node<E> cmp, Node<E> val) {
            return prevUpdater.compareAndSet(this, cmp, val);
        }
    }
}

