/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.resource;

import io.undertow.UndertowLogger;
import io.undertow.server.handlers.cache.DirectBufferCache;
import io.undertow.server.handlers.cache.LRUCache;
import io.undertow.server.handlers.resource.CachedResource;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceChangeEvent;
import io.undertow.server.handlers.resource.ResourceChangeListener;
import io.undertow.server.handlers.resource.ResourceManager;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;

public class CachingResourceManager
implements ResourceManager {
    private final long maxFileSize;
    private final ResourceManager underlyingResourceManager;
    private final DirectBufferCache dataCache;
    private final LRUCache<String, Object> cache;
    private final int maxAge;

    public CachingResourceManager(int metadataCacheSize, long maxFileSize, DirectBufferCache dataCache, ResourceManager underlyingResourceManager, int maxAge) {
        this.maxFileSize = maxFileSize;
        this.underlyingResourceManager = underlyingResourceManager;
        this.dataCache = dataCache;
        this.cache = new LRUCache(metadataCacheSize, maxAge);
        this.maxAge = maxAge;
        if (underlyingResourceManager.isResourceChangeListenerSupported()) {
            try {
                underlyingResourceManager.registerResourceChangeListener(new ResourceChangeListener(){

                    @Override
                    public void handleChanges(Collection<ResourceChangeEvent> changes) {
                        for (ResourceChangeEvent change : changes) {
                            CachingResourceManager.this.invalidate(change.getResource());
                        }
                    }
                });
            }
            catch (Exception e) {
                UndertowLogger.ROOT_LOGGER.couldNotRegisterChangeListener(e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CachedResource getResource(String path) throws IOException {
        Resource underlying;
        Object res = this.cache.get(path);
        if (res instanceof NoResourceMarker) {
            NoResourceMarker marker = (NoResourceMarker)res;
            long nextCheck = marker.getNextCheckTime();
            if (nextCheck <= 0L) return null;
            long time = System.currentTimeMillis();
            if (time <= nextCheck) return null;
            marker.setNextCheckTime(time + (long)this.maxAge);
            if (this.underlyingResourceManager.getResource(path) == null) return null;
            this.cache.remove(path);
        } else if (res != null) {
            CachedResource resource = (CachedResource)res;
            if (resource.checkStillValid()) {
                return resource;
            }
            this.invalidate(path);
        }
        if ((underlying = this.underlyingResourceManager.getResource(path)) == null) {
            this.cache.add(path, new NoResourceMarker(this.maxAge > 0 ? System.currentTimeMillis() + (long)this.maxAge : -1L));
            return null;
        }
        CachedResource resource = new CachedResource(this, underlying, path);
        this.cache.add(path, resource);
        return resource;
    }

    @Override
    public boolean isResourceChangeListenerSupported() {
        return this.underlyingResourceManager.isResourceChangeListenerSupported();
    }

    @Override
    public void registerResourceChangeListener(ResourceChangeListener listener) {
        this.underlyingResourceManager.registerResourceChangeListener(listener);
    }

    @Override
    public void removeResourceChangeListener(ResourceChangeListener listener) {
        this.underlyingResourceManager.removeResourceChangeListener(listener);
    }

    public void invalidate(String path) {
        Object entry = this.cache.remove(path);
        if (entry instanceof CachedResource) {
            ((CachedResource)entry).invalidate();
        }
    }

    DirectBufferCache getDataCache() {
        return this.dataCache;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            if (this.dataCache != null) {
                Set<Object> keys = this.dataCache.getAllKeys();
                for (Object key : keys) {
                    if (!(key instanceof CachedResource.CacheKey) || ((CachedResource.CacheKey)key).manager != this) continue;
                    this.dataCache.remove(key);
                }
            }
        }
        finally {
            this.underlyingResourceManager.close();
        }
    }

    private static final class NoResourceMarker {
        volatile long nextCheckTime;

        private NoResourceMarker(long nextCheckTime) {
            this.nextCheckTime = nextCheckTime;
        }

        public long getNextCheckTime() {
            return this.nextCheckTime;
        }

        public void setNextCheckTime(long nextCheckTime) {
            this.nextCheckTime = nextCheckTime;
        }
    }
}

