/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.okhttp3.internal.tls;

import io.trino.jdbc.$internal.okhttp3.internal.Util;
import io.trino.jdbc.$internal.okhttp3.internal.tls.DistinguishedNameParser;
import io.trino.jdbc.$internal.okhttp3.internal.tls.OkHostnameVerifier;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;

public class LegacyHostnameVerifier
implements HostnameVerifier {
    public static final HostnameVerifier INSTANCE = new LegacyHostnameVerifier();

    private LegacyHostnameVerifier() {
    }

    @Override
    public boolean verify(String host, SSLSession session) {
        if (OkHostnameVerifier.INSTANCE.verify(host, session)) {
            return true;
        }
        if (Util.verifyAsIpAddress(host)) {
            return false;
        }
        try {
            Certificate[] certificates = session.getPeerCertificates();
            X509Certificate certificate = (X509Certificate)certificates[0];
            if (!OkHostnameVerifier.allSubjectAltNames(certificate).isEmpty()) {
                return false;
            }
            X500Principal principal = certificate.getSubjectX500Principal();
            String cn = new DistinguishedNameParser(principal).findMostSpecific("cn");
            if (cn != null) {
                return OkHostnameVerifier.INSTANCE.verifyHostname(host, cn);
            }
            return false;
        }
        catch (SSLException e) {
            return false;
        }
    }
}

