/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.net.jodah.failsafe;

import io.trino.jdbc.$internal.net.jodah.failsafe.AbstractExecution;
import io.trino.jdbc.$internal.net.jodah.failsafe.CircuitBreakerExecutor;
import io.trino.jdbc.$internal.net.jodah.failsafe.DelayablePolicy;
import io.trino.jdbc.$internal.net.jodah.failsafe.ExecutionContext;
import io.trino.jdbc.$internal.net.jodah.failsafe.PolicyExecutor;
import io.trino.jdbc.$internal.net.jodah.failsafe.function.CheckedRunnable;
import io.trino.jdbc.$internal.net.jodah.failsafe.internal.CircuitBreakerInternals;
import io.trino.jdbc.$internal.net.jodah.failsafe.internal.CircuitState;
import io.trino.jdbc.$internal.net.jodah.failsafe.internal.ClosedState;
import io.trino.jdbc.$internal.net.jodah.failsafe.internal.HalfOpenState;
import io.trino.jdbc.$internal.net.jodah.failsafe.internal.OpenState;
import io.trino.jdbc.$internal.net.jodah.failsafe.internal.util.Assert;
import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class CircuitBreaker<R>
extends DelayablePolicy<CircuitBreaker<R>, R> {
    private final AtomicReference<CircuitState> state = new AtomicReference();
    private final AtomicInteger currentExecutions = new AtomicInteger();
    private Duration delay = Duration.ofMinutes(1L);
    private int failureThreshold = 1;
    private int failureRateThreshold;
    private int failureThresholdingCapacity = 1;
    private int failureExecutionThreshold;
    private Duration failureThresholdingPeriod;
    private int successThreshold;
    private int successThresholdingCapacity;
    CheckedRunnable onOpen;
    CheckedRunnable onHalfOpen;
    CheckedRunnable onClose;
    final CircuitBreakerInternals internals = new CircuitBreakerInternals(){

        @Override
        public int getCurrentExecutions() {
            return CircuitBreaker.this.currentExecutions.get();
        }

        @Override
        public void open(ExecutionContext context) {
            CircuitBreaker.this.transitionTo(State.OPEN, CircuitBreaker.this.onOpen, context);
        }
    };

    public CircuitBreaker() {
        this.failureConditions = new ArrayList();
        this.state.set(new ClosedState(this, this.internals));
    }

    public boolean allowsExecution() {
        return this.state.get().allowsExecution();
    }

    public void close() {
        this.transitionTo(State.CLOSED, this.onClose, null);
    }

    public State getState() {
        return this.state.get().getState();
    }

    public Duration getDelay() {
        return this.delay;
    }

    public int getExecutionCount() {
        return this.state.get().getStats().getExecutionCount();
    }

    public Duration getRemainingDelay() {
        return this.state.get().getRemainingDelay();
    }

    public long getFailureCount() {
        return this.state.get().getStats().getFailureCount();
    }

    public int getFailureThresholdingCapacity() {
        return this.failureThresholdingCapacity;
    }

    public Duration getFailureThresholdingPeriod() {
        return this.failureThresholdingPeriod;
    }

    public int getFailureExecutionThreshold() {
        return this.failureExecutionThreshold;
    }

    public int getFailureRate() {
        return this.state.get().getStats().getFailureRate();
    }

    public int getFailureRateThreshold() {
        return this.failureRateThreshold;
    }

    public int getFailureThreshold() {
        return this.failureThreshold;
    }

    public int getSuccessCount() {
        return this.state.get().getStats().getSuccessCount();
    }

    public int getSuccessThresholdingCapacity() {
        return this.successThresholdingCapacity;
    }

    public int getSuccessRate() {
        return this.state.get().getStats().getSuccessRate();
    }

    public int getSuccessThreshold() {
        return this.successThreshold;
    }

    public void halfOpen() {
        this.transitionTo(State.HALF_OPEN, this.onHalfOpen, null);
    }

    public boolean isClosed() {
        return State.CLOSED.equals((Object)this.getState());
    }

    public boolean isHalfOpen() {
        return State.HALF_OPEN.equals((Object)this.getState());
    }

    public boolean isOpen() {
        return State.OPEN.equals((Object)this.getState());
    }

    public CircuitBreaker<R> onClose(CheckedRunnable runnable) {
        this.onClose = runnable;
        return this;
    }

    public CircuitBreaker<R> onHalfOpen(CheckedRunnable runnable) {
        this.onHalfOpen = runnable;
        return this;
    }

    public CircuitBreaker<R> onOpen(CheckedRunnable runnable) {
        this.onOpen = runnable;
        return this;
    }

    public void open() {
        this.transitionTo(State.OPEN, this.onOpen, null);
    }

    public void preExecute() {
        this.currentExecutions.incrementAndGet();
    }

    public void recordFailure() {
        this.recordExecutionFailure(null);
    }

    public void recordFailure(Throwable failure) {
        this.recordResult(null, failure);
    }

    public void recordResult(R result) {
        this.recordResult(result, null);
    }

    public void recordSuccess() {
        try {
            this.state.get().recordSuccess();
        }
        finally {
            this.currentExecutions.decrementAndGet();
        }
    }

    public String toString() {
        return this.getState().toString();
    }

    public CircuitBreaker<R> withDelay(Duration delay) {
        Assert.notNull(delay, "delay");
        Assert.isTrue(delay.toNanos() >= 0L, "delay must be positive", new Object[0]);
        this.delay = delay;
        return this;
    }

    public CircuitBreaker<R> withFailureThreshold(int failureThreshold) {
        return this.withFailureThreshold(failureThreshold, failureThreshold);
    }

    public synchronized CircuitBreaker<R> withFailureThreshold(int failureThreshold, int failureThresholdingCapacity) {
        Assert.isTrue(failureThreshold >= 1, "failureThreshold must be >= 1", new Object[0]);
        Assert.isTrue(failureThresholdingCapacity >= 1, "failureThresholdingCapacity must be >= 1", new Object[0]);
        Assert.isTrue(failureThresholdingCapacity >= failureThreshold, "failureThresholdingCapacity must be >= failureThreshold", new Object[0]);
        this.failureThreshold = failureThreshold;
        this.failureThresholdingCapacity = failureThresholdingCapacity;
        this.state.get().handleConfigChange();
        return this;
    }

    public synchronized CircuitBreaker<R> withFailureThreshold(int failureThreshold, Duration failureThresholdingPeriod) {
        return this.withFailureThreshold(failureThreshold, failureThreshold, failureThresholdingPeriod);
    }

    public synchronized CircuitBreaker<R> withFailureThreshold(int failureThreshold, int failureExecutionThreshold, Duration failureThresholdingPeriod) {
        Assert.isTrue(failureThreshold >= 1, "failureThreshold must be >= 1", new Object[0]);
        Assert.isTrue(failureExecutionThreshold >= failureThreshold, "failureExecutionThreshold must be >= failureThreshold", new Object[0]);
        this.assertFailureExecutionThreshold(failureExecutionThreshold);
        this.assertFailureThresholdingPeriod(failureThresholdingPeriod);
        this.failureThreshold = failureThreshold;
        this.failureThresholdingCapacity = failureThreshold;
        this.failureExecutionThreshold = failureExecutionThreshold;
        this.failureThresholdingPeriod = failureThresholdingPeriod;
        this.state.get().handleConfigChange();
        return this;
    }

    public synchronized CircuitBreaker<R> withFailureRateThreshold(int failureRateThreshold, int failureExecutionThreshold, Duration failureThresholdingPeriod) {
        Assert.isTrue(failureRateThreshold >= 1 && failureRateThreshold <= 100, "failureRateThreshold must be between 1 and 100", new Object[0]);
        this.assertFailureExecutionThreshold(failureExecutionThreshold);
        this.assertFailureThresholdingPeriod(failureThresholdingPeriod);
        this.failureRateThreshold = failureRateThreshold;
        this.failureExecutionThreshold = failureExecutionThreshold;
        this.failureThresholdingPeriod = failureThresholdingPeriod;
        this.state.get().handleConfigChange();
        return this;
    }

    private void assertFailureExecutionThreshold(int failureExecutionThreshold) {
        Assert.isTrue(failureExecutionThreshold >= 1, "failureExecutionThreshold must be >= 1", new Object[0]);
    }

    private void assertFailureThresholdingPeriod(Duration failureThresholdingPeriod) {
        Assert.notNull(failureThresholdingPeriod, "failureThresholdingPeriod");
        Assert.isTrue(failureThresholdingPeriod.toMillis() >= 10L, "failureThresholdingPeriod must be >= 10 ms", new Object[0]);
    }

    public CircuitBreaker<R> withSuccessThreshold(int successThreshold) {
        return this.withSuccessThreshold(successThreshold, successThreshold);
    }

    public synchronized CircuitBreaker<R> withSuccessThreshold(int successThreshold, int successThresholdingCapacity) {
        Assert.isTrue(successThreshold >= 1, "successThreshold must be >= 1", new Object[0]);
        Assert.isTrue(successThresholdingCapacity >= 1, "successThresholdingCapacity must be >= 1", new Object[0]);
        Assert.isTrue(successThresholdingCapacity >= successThreshold, "successThresholdingCapacity must be >= successThreshold", new Object[0]);
        this.successThreshold = successThreshold;
        this.successThresholdingCapacity = successThresholdingCapacity;
        this.state.get().handleConfigChange();
        return this;
    }

    void recordResult(R result, Throwable failure) {
        try {
            if (this.isFailure(result, failure)) {
                this.state.get().recordFailure(null);
            } else {
                this.state.get().recordSuccess();
            }
        }
        finally {
            this.currentExecutions.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transitionTo(State newState, CheckedRunnable listener, ExecutionContext context) {
        boolean transitioned = false;
        CircuitBreaker circuitBreaker = this;
        synchronized (circuitBreaker) {
            if (!this.getState().equals((Object)newState)) {
                switch (newState) {
                    case CLOSED: {
                        this.state.set(new ClosedState(this, this.internals));
                        break;
                    }
                    case OPEN: {
                        Duration computedDelay = this.computeDelay(context);
                        this.state.set(new OpenState(this, this.state.get(), computedDelay != null ? computedDelay : this.delay));
                        break;
                    }
                    case HALF_OPEN: {
                        this.state.set(new HalfOpenState(this, this.internals));
                    }
                }
                transitioned = true;
            }
        }
        if (transitioned && listener != null) {
            try {
                listener.run();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    void recordExecutionFailure(ExecutionContext context) {
        try {
            this.state.get().recordFailure(context);
        }
        finally {
            this.currentExecutions.decrementAndGet();
        }
    }

    @Override
    public PolicyExecutor toExecutor(AbstractExecution execution) {
        return new CircuitBreakerExecutor(this, execution);
    }

    public static enum State {
        CLOSED,
        OPEN,
        HALF_OPEN;

    }
}

