/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client.auth.external;

import io.trino.jdbc.;
import io.trino.jdbc.$internal.client.ClientException;
import io.trino.jdbc.$internal.client.auth.external.RedirectHandler;
import io.trino.jdbc.$internal.client.auth.external.TokenPollResult;
import io.trino.jdbc.$internal.client.auth.external.TokenPoller;
import java.net.URI;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

class ExternalAuthentication {
    private final URI tokenUri;
    private final Optional<URI> redirectUri;

    public ExternalAuthentication(URI tokenUri, Optional<URI> redirectUri) {
        this.tokenUri = Objects.requireNonNull(tokenUri, "tokenUri is null");
        this.redirectUri = Objects.requireNonNull(redirectUri, "redirectUri is null");
    }

    public Optional<.Token> obtainToken(Duration timeout, RedirectHandler handler, TokenPoller poller) {
        TokenPollResult result;
        this.redirectUri.ifPresent(handler::redirectTo);
        URI currentUri = this.tokenUri;
        long start = System.nanoTime();
        long timeoutNanos = timeout.toNanos();
        while (true) {
            long remaining;
            if ((remaining = timeoutNanos - (System.nanoTime() - start)) < 0L) {
                return Optional.empty();
            }
            result = poller.pollForToken(currentUri, Duration.ofNanos(remaining));
            if (result.isFailed()) {
                throw new ClientException(result.getError());
            }
            if (!result.isPending()) break;
            currentUri = result.getNextTokenUri();
        }
        return Optional.of(result.getToken());
    }

    @.VisibleForTesting
    Optional<URI> getRedirectUri() {
        return this.redirectUri;
    }

    @.VisibleForTesting
    URI getTokenUri() {
        return this.tokenUri;
    }
}

