/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.airlift.concurrent;

import io.trino.jdbc.;
import io.trino.jdbc.$internal.guava.base.Preconditions;
import io.trino.jdbc.$internal.guava.util.concurrent.FutureCallback;
import io.trino.jdbc.$internal.guava.util.concurrent.Futures;
import io.trino.jdbc.$internal.guava.util.concurrent.ListenableFuture;
import io.trino.jdbc.$internal.guava.util.concurrent.MoreExecutors;
import io.trino.jdbc.$internal.guava.util.concurrent.SettableFuture;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

@.ThreadSafe
public class AsyncSemaphore<T> {
    private final Queue<QueuedTask<T>> queuedTasks = new ConcurrentLinkedQueue<QueuedTask<T>>();
    private final AtomicInteger counter = new AtomicInteger();
    private final Runnable runNextTask = this::runNext;
    private final int maxPermits;
    private final Executor submitExecutor;
    private final Function<T, ListenableFuture<?>> submitter;

    public AsyncSemaphore(int maxPermits, Executor submitExecutor, Function<T, ListenableFuture<?>> submitter) {
        Preconditions.checkArgument(maxPermits > 0, "must have at least one permit");
        this.maxPermits = maxPermits;
        this.submitExecutor = Objects.requireNonNull(submitExecutor, "submitExecutor is null");
        this.submitter = Objects.requireNonNull(submitter, "submitter is null");
    }

    public ListenableFuture<?> submit(T task) {
        QueuedTask queuedTask = new QueuedTask(task);
        this.queuedTasks.add(queuedTask);
        this.acquirePermit();
        return queuedTask.getCompletionFuture();
    }

    private void acquirePermit() {
        if (this.counter.incrementAndGet() <= this.maxPermits) {
            this.submitExecutor.execute(this.runNextTask);
        }
    }

    private void releasePermit() {
        if (this.counter.getAndDecrement() > this.maxPermits) {
            this.submitExecutor.execute(this.runNextTask);
        }
    }

    private void runNext() {
        final QueuedTask<T> queuedTask = this.queuedTasks.poll();
        ListenableFuture<?> future = this.submitTask(queuedTask.getTask());
        FutureCallback<Object> callback = new FutureCallback<Object>(){

            @Override
            public void onSuccess(Object result) {
                queuedTask.markCompleted();
                AsyncSemaphore.this.releasePermit();
            }

            @Override
            public void onFailure(Throwable t) {
                queuedTask.markFailure(t);
                AsyncSemaphore.this.releasePermit();
            }
        };
        Futures.addCallback(future, callback, MoreExecutors.directExecutor());
    }

    private ListenableFuture<?> submitTask(T task) {
        try {
            ListenableFuture<?> future = this.submitter.apply(task);
            if (future == null) {
                return Futures.immediateFailedFuture(new NullPointerException("Submitter returned a null future for task: " + task));
            }
            return future;
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture(e);
        }
    }

    private static class QueuedTask<T> {
        private final T task;
        private final SettableFuture<?> settableFuture = SettableFuture.create();

        private QueuedTask(T task) {
            this.task = Objects.requireNonNull(task, "task is null");
        }

        public T getTask() {
            return this.task;
        }

        public void markFailure(Throwable throwable) {
            this.settableFuture.setException(throwable);
        }

        public void markCompleted() {
            this.settableFuture.set(null);
        }

        public ListenableFuture<?> getCompletionFuture() {
            return this.settableFuture;
        }
    }
}

