/*
 * Decompiled with CFR 0.152.
 */
package io.takari.resolution;

import java.io.Serializable;

public class Artifact
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String classifier;
    private final String extension;
    private final String coordinate;

    public Artifact(String coords) {
        String[] parts = coords.split(":");
        if (parts.length < 3) {
            throw new IllegalArgumentException("Bad artifact coordinates " + coords + ", expected format is <groupId>:<artifactId>[:<extension>[:<classifier>]]:<version>");
        }
        this.groupId = parts[0];
        this.artifactId = parts[1];
        switch (parts.length) {
            case 3: {
                this.extension = "jar";
                this.classifier = null;
                this.version = parts[2];
                break;
            }
            case 4: {
                this.extension = parts[2];
                this.classifier = null;
                this.version = parts[3];
                break;
            }
            case 5: {
                this.extension = parts[2].isEmpty() ? "jar" : parts[2];
                this.classifier = parts[3];
                this.version = parts[4];
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad artifact coordinates " + coords + ", expected format is <groupId>:<artifactId>[:<extension>[:<classifier>]]:<version>");
            }
        }
        this.coordinate = coords;
    }

    public Artifact(String groupId, String artifactId, String classifier, String extension, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.classifier = classifier;
        this.extension = extension;
        this.version = version;
        this.coordinate = this.coordinate();
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getCoordinate() {
        return this.coordinate;
    }

    public String coordinate() {
        StringBuffer path = new StringBuffer().append(this.groupId).append(':').append(this.artifactId).append(':');
        if (this.extension != null) {
            path.append(this.extension).append(':');
            if (this.classifier != null) {
                path.append(this.classifier).append(':');
            }
        }
        path.append(this.version);
        return path.toString();
    }

    public String toString() {
        return this.coordinate;
    }
}

