/*
 * Decompiled with CFR 0.152.
 */
package io.takari.project.generator;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import io.takari.graph.dot.Edge;
import io.takari.graph.dot.Graph;
import io.takari.graph.dot.Node;
import io.takari.project.generator.JavaSourceGenerator;
import io.takari.project.generator.ProjectGenerator;
import io.takari.resolution.Artifact;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedHashMap;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;

public abstract class AbstractProjectGenerator
implements ProjectGenerator {
    private final File dot;
    private final JavaSourceGenerator java;

    public AbstractProjectGenerator(File dot) {
        this.dot = dot;
        this.java = new JavaSourceGenerator();
    }

    @Override
    public void generate(File outputDirectory) throws Exception {
        Graph graph = this.parse(this.dot);
        String parentArtifactId = graph.attributes().get("artifactId");
        String groupId = graph.attributes().get("groupId");
        String version = graph.attributes().get("version");
        String versionRange = graph.attributes().get("versionRange");
        Preconditions.checkArgument((groupId != null ? 1 : 0) != 0, (Object)"You must specify a groupId attribute in the graph.");
        Preconditions.checkArgument((version != null ? 1 : 0) != 0, (Object)"You must specify a version attribute in the graph.");
        graph.attributes().put("home", System.getProperty("user.home"));
        LinkedHashMap models = Maps.newLinkedHashMap();
        for (Node n : graph.getNodes()) {
            String artifactId = n.getId();
            if (this.is3rdParty(artifactId)) continue;
            Model model = this.model(parentArtifactId, versionRange, groupId, artifactId, version);
            models.put(artifactId, model);
        }
        if (graph.getEdges() != null) {
            for (Edge e : graph.getEdges()) {
                String source = e.getStart().getId();
                String target = e.getEnd().getId();
                Model model = (Model)models.get(source);
                Dependency d = new Dependency();
                if (this.is3rdParty(target)) {
                    Artifact a = new Artifact(target.replaceAll("^\"|\"$", ""));
                    d.setGroupId(a.getGroupId());
                    d.setArtifactId(a.getArtifactId());
                    d.setVersion(a.getVersion());
                    if (a.getClassifier() != null) {
                        d.setClassifier(a.getClassifier());
                    }
                } else {
                    d.setGroupId(groupId);
                    d.setArtifactId(target);
                    d.setVersion(versionRange);
                }
                model.addDependency(d);
            }
        }
        for (Model m : models.values()) {
            File projectOutputDirectory = new File(outputDirectory, m.getArtifactId());
            File pom = new File(projectOutputDirectory, "pom.xml");
            if (!pom.getParentFile().exists()) {
                pom.getParentFile().mkdirs();
            }
            System.out.println("Generating " + m);
            AbstractProjectGenerator.write(m, new OutputStreamWriter(new FileOutputStream(pom)));
            String packageName = groupId;
            String className = "App";
            File source = new File(projectOutputDirectory, "src/main/java");
            this.java.generate(packageName, className, source);
        }
        Model model = this.model(groupId, parentArtifactId, version);
        model.setPackaging("pom");
        for (Model m : models.values()) {
            model.addModule(m.getArtifactId());
        }
        File pom = new File(outputDirectory, "pom.xml");
        if (!pom.getParentFile().exists()) {
            pom.getParentFile().mkdirs();
        }
        this.generate(model, graph.attributes(), new OutputStreamWriter(new FileOutputStream(pom)));
        System.out.println("Generating " + model);
        this.fromTemplate("workspace.xml", graph.attributes(), outputDirectory);
        this.fromTemplate("workspace-user.xml", graph.attributes(), outputDirectory);
        System.out.println("Complete.");
    }

    public abstract Graph parse(File var1) throws Exception;

    private static void write(Model model, Writer writer) throws Exception {
        MavenXpp3Writer modelWriter = new MavenXpp3Writer();
        modelWriter.write(writer, model);
    }

    private Model model(String parentArtifactId, String parentVersion, String groupId, String artifactId, String version) {
        Model model = this.model(groupId, artifactId, version);
        Parent parent = new Parent();
        parent.setGroupId(groupId);
        parent.setArtifactId(parentArtifactId);
        parent.setVersion(parentVersion);
        model.setParent(parent);
        model.setPackaging("${projectLifecycle}");
        return model;
    }

    private Model model(String groupId, String artifactId, String version) {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setGroupId(groupId);
        model.setArtifactId(artifactId);
        model.setVersion(version);
        return model;
    }

    public void generate(Model model, Object context, Writer writer) throws IOException {
        DefaultMustacheFactory mf = new DefaultMustacheFactory();
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("pom-parent.mustache");){
            InputStreamReader reader = new InputStreamReader(is);
            Mustache mustache = mf.compile((Reader)reader, "project");
            mustache.execute(writer, new Object[]{model, context}).flush();
        }
    }

    public void fromTemplate(String template, Object context, File outputDirectory) throws IOException {
        DefaultMustacheFactory mf = new DefaultMustacheFactory();
        File target = new File(outputDirectory, template);
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(template);
             OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(target));){
            InputStreamReader reader = new InputStreamReader(is);
            Mustache mustache = mf.compile((Reader)reader, "project");
            mustache.execute((Writer)writer, context).flush();
        }
    }

    boolean is3rdParty(String nodeId) {
        return nodeId.length() - nodeId.replace(":", "").length() >= 2;
    }
}

