/*
 * Decompiled with CFR 0.152.
 */
package io.takari.graph.dot;

import com.google.common.collect.Maps;
import io.takari.graph.dot.BasicNode;
import io.takari.graph.dot.DotUtils;
import io.takari.graph.dot.Edge;
import io.takari.graph.dot.Node;
import io.takari.graph.dot.Point;
import io.takari.graph.dot.Record;
import io.takari.graph.dot.Rectangle;
import io.takari.graph.dot.SubGraph;
import io.takari.graph.dot.SubRecord;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.Map;

public class Graph {
    public static final int TB = 0;
    public static final int LR = 1;
    public static final int BT = 2;
    public static final int RL = 3;
    public static final int BL = 4;
    public static final int BR = 5;
    public static final int TL = 6;
    public static final int TR = 7;
    public static final int RB = 8;
    public static final int RT = 9;
    public static final int LB = 10;
    public static final int LT = 11;
    public static final int CENTER = 12;
    public static final int LEFT = 13;
    public static final int RIGHT = 14;
    public static final int TOP = 15;
    public static final int BOTTOM = 16;
    public static final int BREADTHFIRST = 17;
    public static final int NODESFIRST = 18;
    public static final int EDGESFIRST = 19;
    public static final int NODE = 20;
    public static final int CLUST = 21;
    public static final int GRAPH = 22;
    public static final double NO_RATIO = -1.0;
    public static final double FILL = -2.0;
    public static final double COMPRESS_RATIO = -3.0;
    public static final double EXPAND = -4.0;
    public static final double AUTO = -5.0;
    public static final String[] ratioAttributeNames = new String[]{"", "fill", "compress", "expand", "auto"};
    public static final int NONE = 23;
    public static final int GLOBAL = 24;
    public static final int LOCAL = 25;
    public static final int SHORTPATH = 26;
    public static final int CIRCUIT = 27;
    public static final int SUBSET = 28;
    public static final int REGULAR = 29;
    public static final int SELF = 30;
    public static final int RANDOM = 31;
    public static final int NO_SPLINES = 32;
    public static final int SPLINES = 33;
    public static final int COMPOUND = 34;
    public static final int RETAIN = 35;
    public static final int SCALE = 36;
    public static final int VORONOI = 37;
    public static final int SCALEXY = 38;
    public static final int ORTHOXY = 39;
    public static final int ORTHOYX = 40;
    public static final int COMPRESS = 41;
    public static final int NO_ORDERING = 42;
    public static final int IN = 43;
    public static final int OUT = 44;
    public static final int MAJOR = 45;
    public static final int KK = 46;
    public static final int UTF_8 = 47;
    public static final int ISO_8859_1 = 48;
    public static final int NO_SEED = -1;
    private final String[] attributeNames = new String[]{"TB", "LR", "BT", "RL", "BL", "BR", "TL", "TR", "RB", "RT", "LB", "LT", "c", "l", "r", "t", "b", "breadthfirst", "nodesfirst", "edgesfirst", "node", "clust", "graph", "none", "global", "local", "shortpath", "circuit", "subset", "regular", "self", "random", "false", "true", "compound", "true", "scale", "false", "scalexy", "orthoxy", "orthoyx", "compress", "", "in", "out", "major", "KK", "UTF-8", "iso-8859-1"};
    Node[] nodes;
    Node[] genericNodes;
    Edge[] edges;
    public String id;
    public String URL;
    public String fontname = "Times-Roman";
    public String label = "";
    public String target;
    public String stylesheet;
    public int charset = 47;
    public String[] fontpath = null;
    public String[] layers = null;
    public String layersep = "";
    public boolean directed;
    public boolean center = false;
    public boolean compound = false;
    public boolean concentrate = false;
    public boolean nojustify = false;
    public boolean normalize = false;
    public boolean remincross = false;
    public Boolean truecolor = null;
    public int rankdir = 0;
    public int dim = 2;
    public int labeljust = 12;
    public int labelloc = 16;
    public int outputorder = 17;
    public boolean pack = false;
    public int packValue = 8;
    public int packmode = 20;
    public int pagedir = 4;
    public int rotate = 0;
    public int samplepoints = 8;
    public int searchsize = 30;
    public int showboxes = 0;
    public int clusterrank = 25;
    public int model = 26;
    public int startStyle = 31;
    public int startSeed = -1;
    public int splines = 32;
    public int overlap = 35;
    public int ordering = 42;
    public int maxiter;
    public int mode = 45;
    public double damping = 0.99;
    public double k = 0.3;
    public double fontsize = 14.0;
    public double mclimit = 1.0;
    public double mindist = 1.0;
    public double nodesep = 0.25;
    public double quantum = 0.0;
    public double ranksep;
    public double ratio = -1.0;
    public double sep = 0.01;
    public double voro_margin = 0.05;
    public double dpi = 96.0;
    public double defaultdist;
    public double epsilon;
    public Color bgcolor;
    public Color fontcolor = Color.black;
    public Node graphRoot;
    public Rectangle bb;
    public Point lp;
    public Point2D.Double page;
    public Point2D.Double size;
    public Point2D.Double margin = new Point2D.Double(0.11, 0.055);
    public BasicNode genericNode = null;
    public Record genericRecord = null;
    public Edge genericEdge = null;
    boolean record = false;
    Map<String, String> attributes = Maps.newHashMap();

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public Graph() throws Exception {
        this.genericNode = new BasicNode(this, "node");
        this.genericRecord = new Record(this, "node");
        this.genericEdge = new Edge(this, this.genericNode, this.genericRecord);
    }

    public Graph(String id) throws Exception {
        this.genericNode = new BasicNode(this, "node");
        this.genericRecord = new Record(this, "node");
        this.genericEdge = new Edge(this, this.genericNode, this.genericRecord);
        this.id = id;
    }

    public void addNode(Node node) {
        if (this.genericNodes == null) {
            this.nodes = new Node[1];
            this.nodes[0] = node;
            this.genericNodes = this.nodes;
        } else {
            boolean addNode = !(node instanceof SubRecord);
            for (int i = 0; i < this.genericNodes.length; ++i) {
                if (this.genericNodes[i].id != null) {
                    addNode &= !this.genericNodes[i].id.equals(node.id);
                }
                if (!addNode) break;
            }
            if (addNode) {
                if (this.nodes == null) {
                    this.nodes = new Node[1];
                    this.nodes[0] = node;
                } else {
                    Node[] tmp = new Node[this.nodes.length + 1];
                    System.arraycopy(this.nodes, 0, tmp, 0, this.nodes.length);
                    tmp[tmp.length - 1] = node;
                    this.nodes = tmp;
                }
                this.addGenericNode(node);
            }
        }
    }

    public void addGenericNode(Node node) {
        if (this.genericNodes == null) {
            this.genericNodes = new Node[1];
            this.genericNodes[0] = node;
        } else {
            boolean addNode = !(node instanceof SubRecord);
            for (int i = 0; i < this.genericNodes.length; ++i) {
                if (this.genericNodes[i].id != null) {
                    addNode &= !this.genericNodes[i].id.equals(node.id);
                }
                if (!addNode) break;
            }
            if (addNode) {
                Node[] tmp = new Node[this.genericNodes.length + 1];
                System.arraycopy(this.genericNodes, 0, tmp, 0, this.genericNodes.length);
                tmp[tmp.length - 1] = node;
                this.genericNodes = tmp;
            }
        }
    }

    public void addEdge(Edge edge) {
        if (this.edges == null) {
            this.edges = new Edge[1];
            this.edges[0] = edge;
        } else {
            boolean addEdge = true;
            for (int i = 0; i < this.edges.length && (addEdge &= !this.edges[i].start.equals(edge.start) || !this.edges[i].end.equals(edge.end)); ++i) {
            }
            if (addEdge) {
                Edge[] tmp = new Edge[this.edges.length + 1];
                System.arraycopy(this.edges, 0, tmp, 0, this.edges.length);
                tmp[tmp.length - 1] = edge;
                this.edges = tmp;
            }
        }
        Graph.addNode(edge.start.root, edge.start);
        Graph.addNode(edge.end.root, edge.end);
    }

    public static void addNode(Object root, Node element) {
        if (root instanceof Graph) {
            ((Graph)root).addNode(element);
        } else if (root instanceof SubGraph) {
            ((SubGraph)root).addNode(element);
        }
    }

    public void addLayer(String layer) {
        if (this.layers == null) {
            this.layers = new String[1];
            this.layers[0] = layer;
        } else {
            boolean add = true;
            for (int i = 0; i < this.layers.length && (add &= !this.layers[i].equals(layer)); ++i) {
            }
            if (add) {
                String[] tmp = new String[this.layers.length + 1];
                System.arraycopy(this.layers, 0, tmp, 0, this.layers.length);
                tmp[tmp.length - 1] = layer;
                this.layers = tmp;
            }
        }
    }

    public void addFontPath(String path) {
        if (this.fontpath == null) {
            this.fontpath = new String[1];
            this.fontpath[0] = path;
        } else {
            boolean add = true;
            for (int i = 0; i < this.fontpath.length && (add &= !this.fontpath[i].equals(path)); ++i) {
            }
            if (add) {
                String[] tmp = new String[this.fontpath.length + 1];
                System.arraycopy(this.fontpath, 0, tmp, 0, this.fontpath.length);
                tmp[tmp.length - 1] = path;
                this.fontpath = tmp;
            }
        }
    }

    public void removeNode(Node node) {
        int i;
        Edge[] in = node.getIn();
        Edge[] out = node.getOut();
        if (in != null) {
            for (i = 0; i < in.length; ++i) {
                this.removeEdge(in[i]);
            }
        }
        if (out != null) {
            for (i = 0; i < out.length; ++i) {
                this.removeEdge(out[i]);
            }
        }
        if (this.nodes != null) {
            for (i = 0; i < this.nodes.length; ++i) {
                if (!this.nodes[i].equals(node)) continue;
                Node[] tmp = new Node[this.nodes.length - 1];
                System.arraycopy(this.nodes, 0, tmp, 0, i);
                System.arraycopy(this.nodes, i + 1, tmp, i, this.nodes.length - i - 1);
                this.nodes = tmp;
                break;
            }
            if (this.nodes.length == 0) {
                this.nodes = null;
            }
        }
    }

    public void removeEdge(Edge edge) {
        if (this.edges != null) {
            for (int i = 0; i < this.edges.length; ++i) {
                if (!this.edges[i].equals(edge)) continue;
                Edge[] tmp = new Edge[this.edges.length - 1];
                System.arraycopy(this.edges, 0, tmp, 0, i);
                System.arraycopy(this.edges, i + 1, tmp, i, this.edges.length - i - 1);
                this.edges = tmp;
                break;
            }
            if (this.edges.length == 0) {
                this.edges = null;
            }
        }
    }

    public void removeLayer(String layer) {
        if (this.layers != null) {
            for (int i = 0; i < this.layers.length; ++i) {
                if (!this.layers[i].equals(layer)) continue;
                String[] tmp = new String[this.layers.length - 1];
                System.arraycopy(this.layers, 0, tmp, 0, i);
                System.arraycopy(this.layers, i + 1, tmp, i, this.layers.length - i - 1);
                this.layers = tmp;
            }
            if (this.layers.length == 0) {
                this.layers = null;
            }
        }
    }

    public void removeFontPath(String path) {
        if (this.fontpath != null) {
            for (int i = 0; i < this.fontpath.length; ++i) {
                if (!this.fontpath[i].equals(path)) continue;
                String[] tmp = new String[this.fontpath.length - 1];
                System.arraycopy(this.fontpath, 0, tmp, 0, i);
                System.arraycopy(this.fontpath, i + 1, tmp, i, this.fontpath.length - i - 1);
                this.fontpath = tmp;
            }
            if (this.fontpath.length == 0) {
                this.fontpath = null;
            }
        }
    }

    public void changeOption(String name, String value) {
        String v = value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"' ? value.substring(1, value.length() - 1) : value;
        v = v.replaceAll("\\\\\\n", "");
        if (name.equals("bb")) {
            this.bb = DotUtils.readRectangle(v);
        } else if (name.equals("bgcolor")) {
            this.bgcolor = DotUtils.readColor(v);
        } else if (name.equals("center")) {
            this.center = DotUtils.readBoolean(v);
        } else if (name.equals("charset")) {
            this.charset = this.readAttributeNumber(v);
        } else if (name.equals("clusterrank")) {
            this.clusterrank = this.readAttributeNumber(v);
        } else if (name.equals("compound")) {
            this.compound = DotUtils.readBoolean(v);
        } else if (name.equals("concentrate")) {
            this.concentrate = DotUtils.readBoolean(v);
        } else if (name.equals("damping")) {
            this.damping = DotUtils.readDouble(v);
        } else if (name.equals("defaultdist")) {
            this.defaultdist = DotUtils.readDouble(v);
        } else if (name.equals("dim")) {
            this.dim = DotUtils.readInteger(v);
        } else if (name.equals("dpi") || name.equals("resolution")) {
            this.dpi = DotUtils.readDouble(v);
        } else if (name.equals("epsilon")) {
            this.epsilon = DotUtils.readDouble(v);
        } else if (name.equals("fontcolor")) {
            this.fontcolor = DotUtils.readColor(v);
        } else if (name.equals("fontname")) {
            this.fontname = v;
        } else if (name.equals("fontpath")) {
            this.addFontPath(v);
        } else if (name.equals("fontsize")) {
            this.fontsize = DotUtils.readDouble(v);
        } else if (name.equals("k")) {
            this.k = DotUtils.readDouble(v);
        } else if (name.equals("label")) {
            this.label = v;
        } else if (name.equals("labeljust")) {
            this.labeljust = this.readAttributeNumber(v);
        } else if (name.equals("labelloc")) {
            this.labelloc = this.readAttributeNumber(v);
        } else if (name.equals("layers")) {
            this.addLayer(v);
        } else if (name.equals("layersep")) {
            this.layersep = v;
        } else if (name.equals("lp")) {
            this.lp = DotUtils.readPoint(v);
        } else if (name.equals("margin")) {
            this.margin = DotUtils.readPointf(v);
        } else if (name.equals("maxiter")) {
            this.maxiter = DotUtils.readInteger(v);
        } else if (name.equals("mclimit")) {
            this.mclimit = DotUtils.readDouble(v);
        } else if (name.equals("mindist")) {
            this.mindist = DotUtils.readDouble(v);
        } else if (name.equals("mode")) {
            this.mode = this.readAttributeNumber(v);
        } else if (name.equals("model")) {
            this.model = this.readAttributeNumber(v);
        } else if (name.equals("nodesep")) {
            this.nodesep = DotUtils.readDouble(v);
        } else if (name.equals("nojustify")) {
            this.nojustify = DotUtils.readBoolean(v);
        } else if (name.equals("normalize")) {
            this.normalize = DotUtils.readBoolean(v);
        } else if (name.equals("ordering")) {
            this.ordering = this.readAttributeNumber(v);
        } else if (name.equals("outputorder")) {
            this.outputorder = this.readAttributeNumber(v);
        } else if (name.equals("overlap")) {
            this.overlap = this.readAttributeNumber(v);
        } else if (name.equals("pack")) {
            try {
                this.packValue = DotUtils.readInteger(v);
                this.pack = true;
            }
            catch (NumberFormatException e) {
                this.pack = DotUtils.readBoolean(v);
            }
        } else if (name.equals("packmode")) {
            this.packmode = this.readAttributeNumber(v);
        } else if (name.equals("page")) {
            this.page = DotUtils.readPointf(v);
        } else if (name.equals("pagedir")) {
            this.pagedir = this.readAttributeNumber(v);
        } else if (name.equals("quantum")) {
            this.quantum = DotUtils.readDouble(v);
        } else if (name.equals("rankdir")) {
            this.rankdir = this.readAttributeNumber(v);
        } else if (name.equals("ranksep")) {
            this.ranksep = DotUtils.readDouble(v);
        } else if (name.equals("ratio")) {
            this.ratio = this.readRatio(v);
        } else if (name.equals("remincross")) {
            this.remincross = DotUtils.readBoolean(v);
        } else if (name.equals("rotate")) {
            this.rotate = DotUtils.readInteger(v);
        } else if (name.equals("orientation")) {
            if (this.rotate == 0) {
                this.rotate = DotUtils.readOrientation(v);
            } else if (name.equals("samplepoints")) {
                this.samplepoints = DotUtils.readInteger(v);
            } else if (name.equals("searchsize")) {
                this.searchsize = DotUtils.readInteger(v);
            } else if (name.equals("sep")) {
                this.sep = DotUtils.readDouble(v);
            } else if (name.equals("showboxes")) {
                this.showboxes = DotUtils.readInteger(v);
            } else if (name.equals("size")) {
                this.size = DotUtils.readPointf(v);
            } else if (name.equals("splines")) {
                this.splines = this.readAttributeNumber(v);
            } else if (!name.equals("start")) {
                if (name.equals("stylesheet")) {
                    this.stylesheet = v;
                } else if (name.equals("target")) {
                    this.target = v;
                } else if (name.equals("truecolor")) {
                    this.truecolor = new Boolean(DotUtils.readBoolean(v));
                } else if (name.equals("URL") || name.equals("href")) {
                    this.URL = v;
                } else if (name.equals("voro_margin")) {
                    this.voro_margin = DotUtils.readDouble(v);
                } else {
                    System.err.println("No such attribute: " + name);
                }
            }
        } else {
            this.attributes.put(name, v);
        }
    }

    private double readRatio(String v) {
        for (int i = 0; i < ratioAttributeNames.length; ++i) {
            if (!ratioAttributeNames[i].equalsIgnoreCase(v)) continue;
            return -i;
        }
        return -1.0;
    }

    private int readAttributeNumber(String v) {
        for (int i = 0; i < this.attributeNames.length; ++i) {
            if (!this.attributeNames[i].equalsIgnoreCase(v)) continue;
            return i;
        }
        System.err.println("Graph value \"" + v + "\" does not exist");
        return -1;
    }

    public String toString() {
        String g = (this.directed ? "di" : "") + "graph " + this.id + " {\n";
        for (Map.Entry<String, String> e : this.attributes.entrySet()) {
            g = g + String.format("%s=\"%s\";%n", e.getKey(), e.getValue());
        }
        g = g + this.graphOptions();
        if (this.nodes != null) {
            for (int i = 0; i < this.nodes.length; ++i) {
                g = g + this.nodes[i];
            }
        }
        if (this.edges != null) {
            for (int i = 0; i < this.edges.length; ++i) {
                g = g + this.edges[i];
            }
        }
        return g + "}";
    }

    private String graphOptions() {
        String o = "";
        if (this.damping != 0.99) {
            o = o + this.printOption("Damping", this.damping);
        }
        if (this.k != 0.3) {
            o = o + this.printOption("K", this.k);
        }
        if (this.URL != null) {
            o = o + this.printOption("URL", this.URL);
        }
        if (this.bb != null) {
            o = o + this.printOption("bb", this.bb);
        }
        if (this.bgcolor != null) {
            o = o + this.printOption("bgcolor", this.bgcolor);
        }
        if (this.center) {
            o = o + this.printOption("center", this.center);
        }
        if (this.charset != 47) {
            o = o + this.printNamedOption("charset", this.charset);
        }
        if (this.clusterrank != 25) {
            o = o + this.printNamedOption("clusterrank", this.clusterrank);
        }
        if (this.compound) {
            o = o + this.printOption("compound", this.compound);
        }
        if (this.concentrate) {
            o = o + this.printOption("concentrate", this.concentrate);
        }
        if (this.dim != 2) {
            o = o + this.printOption("dim", this.dim);
        }
        if (this.dpi != 96.0) {
            o = o + this.printOption("dpi", this.dpi);
        }
        if (!this.fontcolor.equals(Color.black)) {
            o = o + this.printOption("fontcolor", this.fontcolor);
        }
        if (!this.fontname.equals("Times-Roman")) {
            o = o + this.printOption("fontname", this.fontname);
        }
        if (this.fontsize != 14.0) {
            o = o + this.printOption("fontsize", this.fontsize);
        }
        if (!this.label.equals("")) {
            o = o + this.printOption("label", this.label);
        }
        if (this.labeljust != 12) {
            o = o + this.printNamedOption("labeljust", this.labeljust);
        }
        if (this.labelloc != 16) {
            o = o + this.printNamedOption("labelloc", this.labelloc);
        }
        if (this.layers != null) {
            o = o + this.printOption("layers", this.layers);
        }
        if (!this.layersep.equals("")) {
            o = o + this.printOption("layersep", this.layersep);
        }
        if (this.lp != null) {
            o = o + this.printOption("lp", this.lp);
        }
        if (this.margin != null && (this.margin.x != 0.11 || this.margin.y != 0.055)) {
            o = o + this.printOption("margin", this.margin);
        }
        if (this.mclimit != 1.0) {
            o = o + this.printOption("mclimit", this.mclimit);
        }
        if (this.mindist != 1.0) {
            o = o + this.printOption("mindist", this.mindist);
        }
        if (this.mode != 45) {
            o = o + this.printNamedOption("mode", this.mode);
        }
        if (this.model != 26) {
            o = o + this.printNamedOption("model", this.model);
        }
        if (this.nodesep != 0.25) {
            o = o + this.printOption("nodesep", this.nodesep);
        }
        if (this.nojustify) {
            o = o + this.printOption("nojustify", this.nojustify);
        }
        if (this.normalize) {
            o = o + this.printOption("normalize", this.normalize);
        }
        if (this.ordering != 42) {
            o = o + this.printNamedOption("ordering", this.ordering);
        }
        if (this.rotate != 0) {
            o = o + this.printOption("rotate", this.rotate);
        }
        if (this.outputorder != 17) {
            o = o + this.printNamedOption("outputorder", this.outputorder);
        }
        if (this.overlap != 35) {
            o = o + this.printNamedOption("overlap", this.overlap);
        }
        if (this.pack) {
            o = o + this.printOption("pack", this.pack);
        }
        if (this.packmode != 20) {
            o = o + this.printNamedOption("packmode", this.packmode);
        }
        if (this.page != null) {
            o = o + this.printOption("page", this.page);
        }
        if (this.pagedir != 4) {
            o = o + this.printNamedOption("pagedir", this.pagedir);
        }
        if (this.quantum != 0.0) {
            o = o + this.printOption("quantum", this.quantum);
        }
        if (this.rankdir != 0) {
            o = o + this.printNamedOption("rankdir", this.rankdir);
        }
        if (this.ratio != -1.0) {
            o = o + this.printRatioOption("ratio", this.ratio);
        }
        if (this.remincross) {
            o = o + this.printOption("remincross", this.remincross);
        }
        if (this.graphRoot != null) {
            o = o + this.printOption("root", this.graphRoot);
        }
        if (this.samplepoints != 8) {
            o = o + this.printOption("samplepoints", this.samplepoints);
        }
        if (this.searchsize != 30) {
            o = o + this.printOption("searchsize", this.searchsize);
        }
        if (this.sep != 0.01) {
            o = o + this.printOption("sep", this.sep);
        }
        if (this.showboxes != 0) {
            o = o + this.printOption("showboxes", this.showboxes);
        }
        if (this.size != null) {
            o = o + this.printOption("size", this.size);
        }
        if (this.splines != 32) {
            o = o + this.printNamedOption("splines", this.splines);
        }
        if (this.startStyle != 31) {
            o = o + this.printStartTypeOption("start", this.startStyle);
        }
        if (this.stylesheet != null) {
            o = o + this.printOption("stylesheet", this.stylesheet);
        }
        if (this.target != null) {
            o = o + this.printOption("target", this.target);
        }
        if (this.truecolor != null) {
            o = o + this.printOption("truecolor", this.truecolor);
        }
        if (this.voro_margin != 0.05) {
            o = o + this.printOption("voro_margin", this.voro_margin);
        }
        if (this.fontpath != null) {
            o = o + this.printOption("fontpath", this.fontpath);
        }
        return o;
    }

    private String printOption(String attribute, Node rootNode) {
        return attribute + " = " + rootNode.id + ";\n";
    }

    private String printNamedOption(String attribute, int i) {
        if (i < 0) {
            return "";
        }
        return attribute + " = \"" + this.attributeNames[i] + "\";\n";
    }

    private String printStartTypeOption(String attribute, int i) {
        return attribute + " = \"" + this.attributeNames[i] + (this.startSeed == -1 ? "" : " " + this.startSeed) + "\";\n";
    }

    private String printRatioOption(String attribute, double d) {
        if (d != 0.0) {
            String value = d == -2.0 ? "\"fill\"" : (d == -3.0 ? "\"compress\"" : (d == -4.0 ? "\"expand\"" : (d == -5.0 ? "\"auto\"" : Double.toString(d))));
            return attribute + " = \"" + value + "\";\n";
        }
        return "";
    }

    private String printOption(String attribute, Point2D.Double value) {
        return attribute + " = \"" + value.x + "," + value.y + "\";\n";
    }

    private String printOption(String attribute, Point value) {
        String o = attribute + "=\"";
        for (int i = 0; i < value.coords.length; ++i) {
            if (i > 0) {
                o = o + ",";
            }
            o = o + value.coords[i];
        }
        return o + "\"" + (value.change ? "" : "!") + ";\n";
    }

    private String printOption(String attribute, Rectangle value) {
        return attribute + " = \"" + value.x1 + ", " + value.y1 + ", " + value.x2 + ", " + value.y2 + "\";\n";
    }

    private String printOption(String attribute, Color value) {
        if (value != null) {
            String r = Integer.toHexString(value.getRed());
            String g = Integer.toHexString(value.getGreen());
            String b = Integer.toHexString(value.getBlue());
            String a = Integer.toHexString(value.getAlpha());
            if (r.length() == 1) {
                r = "0" + r;
            }
            if (g.length() == 1) {
                g = "0" + g;
            }
            if (b.length() == 1) {
                b = "0" + b;
            }
            if (a.length() == 1) {
                a = "0" + a;
            }
            return attribute + " = \"#" + r + g + b + a + "\";\n";
        }
        return "";
    }

    private String printOption(String attribute, String[] value) {
        String o = attribute + " = \"";
        for (int i = 0; i < value.length; ++i) {
            if (i > 0) {
                o = o + " ";
            }
            o = o + value[i];
        }
        return o + "\";\n";
    }

    private String printOption(String attribute, String value) {
        if (value != null) {
            return attribute + " = \"" + value + "\";\n";
        }
        return "";
    }

    private String printOption(String attribute, boolean value) {
        return attribute + " = \"" + value + "\";\n";
    }

    private String printOption(String attribute, double value) {
        return attribute + " = " + value + ";\n";
    }

    private String printOption(String attribute, int value) {
        return attribute + " = " + value + ";\n";
    }

    public Edge[] getEdges() {
        return this.edges;
    }

    public Node[] getNodes() {
        return this.nodes;
    }

    public static void main(String[] args) {
        try {
            Graph g = new Graph();
            g.id = "finite_state_machine";
            g.directed = true;
            g.rankdir = 1;
            BasicNode LR_0 = new BasicNode(g, "LR_0");
            BasicNode LR_3 = new BasicNode(g, "LR_3");
            BasicNode LR_4 = new BasicNode(g, "LR_4");
            BasicNode LR_8 = new BasicNode(g, "LR_8");
            BasicNode LR_1 = new BasicNode(g, "LR_1");
            BasicNode LR_2 = new BasicNode(g, "LR_2");
            BasicNode LR_5 = new BasicNode(g, "LR_5");
            BasicNode LR_6 = new BasicNode(g, "LR_6");
            BasicNode LR_7 = new BasicNode(g, "LR_7");
            g.addNode(LR_0);
            g.addNode(LR_3);
            g.addNode(LR_4);
            g.addNode(LR_8);
            LR_0.regular = true;
            LR_0.peripheries = 2;
            LR_3.regular = true;
            LR_3.peripheries = 2;
            LR_4.regular = true;
            LR_4.peripheries = 2;
            LR_8.regular = true;
            LR_8.peripheries = 2;
            LR_1.regular = true;
            LR_2.regular = true;
            LR_5.regular = true;
            LR_6.regular = true;
            LR_7.regular = true;
            Edge e1 = new Edge(g, LR_0, LR_2);
            Edge e2 = new Edge(g, LR_0, LR_1);
            Edge e3 = new Edge(g, LR_1, LR_3);
            Edge e4 = new Edge(g, LR_2, LR_6);
            Edge e5 = new Edge(g, LR_2, LR_5);
            Edge e6 = new Edge(g, LR_2, LR_4);
            Edge e7 = new Edge(g, LR_5, LR_7);
            Edge e8 = new Edge(g, LR_5, LR_5);
            Edge e9 = new Edge(g, LR_6, LR_6);
            Edge e10 = new Edge(g, LR_6, LR_5);
            Edge e11 = new Edge(g, LR_7, LR_8);
            Edge e12 = new Edge(g, LR_7, LR_5);
            Edge e13 = new Edge(g, LR_8, LR_6);
            Edge e14 = new Edge(g, LR_8, LR_5);
            e1.label = "SS(B)";
            e2.label = "SS(S)";
            e3.label = "SS($end)";
            e4.label = "SS(b)";
            e5.label = "SS(a)";
            e6.label = "S(A)";
            e7.label = "S(b)";
            e8.label = "S(a)";
            e9.label = "S(b)";
            e10.label = "S(a)";
            e11.label = "S(b)";
            e12.label = "S(a)";
            e13.label = "S(b)";
            e14.label = "S(a)";
            System.out.println(g);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

