/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.connect.build;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.connect.build.Artifact;
import io.strimzi.crdgenerator.annotations.Description;
import io.vertx.core.cli.annotations.DefaultValue;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"repository", "group", "artifact", "version"})
public class MavenArtifact
extends Artifact {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_REPOSITORY = "https://repo1.maven.org/maven2/";
    private String group;
    private String artifact;
    private String version;
    private String repository;

    @Override
    @Description(value="Must be `maven`")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getType() {
        return "maven";
    }

    @Description(value="Maven group id. Applicable to the `maven` artifact type only.")
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    @Description(value="Maven artifact id. Applicable to the `maven` artifact type only.")
    public String getArtifact() {
        return this.artifact;
    }

    public void setArtifact(String artifact) {
        this.artifact = artifact;
    }

    @Description(value="Maven version number. Applicable to the `maven` artifact type only.")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Description(value="Maven repository to download the artifact from. Applicable to the `maven` artifact type only.")
    @DefaultValue(value="https://repo1.maven.org/maven2/")
    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MavenArtifact)) {
            return false;
        }
        MavenArtifact other = (MavenArtifact)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$group = this.getGroup();
        String other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        String this$artifact = this.getArtifact();
        String other$artifact = other.getArtifact();
        if (this$artifact == null ? other$artifact != null : !this$artifact.equals(other$artifact)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$repository = this.getRepository();
        String other$repository = other.getRepository();
        return !(this$repository == null ? other$repository != null : !this$repository.equals(other$repository));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MavenArtifact;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        String $artifact = this.getArtifact();
        result = result * 59 + ($artifact == null ? 43 : $artifact.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $repository = this.getRepository();
        result = result * 59 + ($repository == null ? 43 : $repository.hashCode());
        return result;
    }
}

