/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.connect.build.DockerOutput;
import io.strimzi.api.kafka.model.connect.build.DockerOutputFluent;
import io.strimzi.api.kafka.model.connect.build.DockerOutputFluentImpl;
import java.util.Objects;

public class DockerOutputBuilder
extends DockerOutputFluentImpl<DockerOutputBuilder>
implements VisitableBuilder<DockerOutput, DockerOutputBuilder> {
    DockerOutputFluent<?> fluent;
    Boolean validationEnabled;

    public DockerOutputBuilder() {
        this(true);
    }

    public DockerOutputBuilder(Boolean validationEnabled) {
        this(new DockerOutput(), validationEnabled);
    }

    public DockerOutputBuilder(DockerOutputFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public DockerOutputBuilder(DockerOutputFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new DockerOutput(), validationEnabled);
    }

    public DockerOutputBuilder(DockerOutputFluent<?> fluent, DockerOutput instance) {
        this(fluent, instance, true);
    }

    public DockerOutputBuilder(DockerOutputFluent<?> fluent, DockerOutput instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withImage(instance.getImage());
        fluent.withPushSecret(instance.getPushSecret());
        fluent.withAdditionalKanikoOptions(instance.getAdditionalKanikoOptions());
        this.validationEnabled = validationEnabled;
    }

    public DockerOutputBuilder(DockerOutput instance) {
        this(instance, (Boolean)true);
    }

    public DockerOutputBuilder(DockerOutput instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withImage(instance.getImage());
        this.withPushSecret(instance.getPushSecret());
        this.withAdditionalKanikoOptions(instance.getAdditionalKanikoOptions());
        this.validationEnabled = validationEnabled;
    }

    public DockerOutput build() {
        DockerOutput buildable = new DockerOutput();
        buildable.setImage(this.fluent.getImage());
        buildable.setPushSecret(this.fluent.getPushSecret());
        buildable.setAdditionalKanikoOptions(this.fluent.getAdditionalKanikoOptions());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DockerOutputBuilder that = (DockerOutputBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

