/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.model.LabelSelector;
import io.strimzi.api.kafka.model.SpecFluentImpl;
import io.strimzi.api.kafka.model.StrimziPodSetSpec;
import io.strimzi.api.kafka.model.StrimziPodSetSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class StrimziPodSetSpecFluentImpl<A extends StrimziPodSetSpecFluent<A>>
extends SpecFluentImpl<A>
implements StrimziPodSetSpecFluent<A> {
    private LabelSelector selector;
    private List<Map<String, Object>> pods;

    public StrimziPodSetSpecFluentImpl() {
    }

    public StrimziPodSetSpecFluentImpl(StrimziPodSetSpec instance) {
        this.withSelector(instance.getSelector());
        this.withPods(instance.getPods());
    }

    @Override
    public LabelSelector getSelector() {
        return this.selector;
    }

    @Override
    public A withSelector(LabelSelector selector) {
        this.selector = selector;
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public A addToPods(int index, Map<String, Object> item) {
        if (this.pods == null) {
            this.pods = new ArrayList<Map<String, Object>>();
        }
        this.pods.add(index, item);
        return (A)this;
    }

    @Override
    public A setToPods(int index, Map<String, Object> item) {
        if (this.pods == null) {
            this.pods = new ArrayList<Map<String, Object>>();
        }
        this.pods.set(index, item);
        return (A)this;
    }

    @Override
    public A addToPods(Map<String, Object> ... items) {
        if (this.pods == null) {
            this.pods = new ArrayList<Map<String, Object>>();
        }
        for (Map<String, Object> item : items) {
            this.pods.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToPods(Collection<Map<String, Object>> items) {
        if (this.pods == null) {
            this.pods = new ArrayList<Map<String, Object>>();
        }
        for (Map<String, Object> item : items) {
            this.pods.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromPods(Map<String, Object> ... items) {
        for (Map<String, Object> item : items) {
            if (this.pods == null) continue;
            this.pods.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPods(Collection<Map<String, Object>> items) {
        for (Map<String, Object> item : items) {
            if (this.pods == null) continue;
            this.pods.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Map<String, Object>> getPods() {
        return this.pods;
    }

    @Override
    public Map<String, Object> getPod(int index) {
        return this.pods.get(index);
    }

    @Override
    public Map<String, Object> getFirstPod() {
        return this.pods.get(0);
    }

    @Override
    public Map<String, Object> getLastPod() {
        return this.pods.get(this.pods.size() - 1);
    }

    @Override
    public Map<String, Object> getMatchingPod(Predicate<Map<String, Object>> predicate) {
        for (Map<String, Object> item : this.pods) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPod(Predicate<Map<String, Object>> predicate) {
        for (Map<String, Object> item : this.pods) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <K, V> A withPods(List<Map<String, Object>> pods) {
        if (this.pods != null) {
            this._visitables.get((Object)"pods").removeAll(this.pods);
        }
        if (pods != null) {
            this.pods = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> item : pods) {
                this.addToPods(item);
            }
        } else {
            this.pods = null;
        }
        return (A)this;
    }

    @Override
    public A withPods(Map<String, Object> ... pods) {
        if (this.pods != null) {
            this.pods.clear();
        }
        if (pods != null) {
            for (Map<String, Object> item : pods) {
                this.addToPods(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPods() {
        return this.pods != null && !this.pods.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StrimziPodSetSpecFluentImpl that = (StrimziPodSetSpecFluentImpl)o;
        if (this.selector != null ? !this.selector.equals((Object)that.selector) : that.selector != null) {
            return false;
        }
        return !(this.pods != null ? !this.pods.equals(that.pods) : that.pods != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.selector, this.pods, super.hashCode());
    }
}

