/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.Rack;
import io.strimzi.api.kafka.model.RackFluent;
import io.strimzi.api.kafka.model.RackFluentImpl;
import java.util.Objects;

public class RackBuilder
extends RackFluentImpl<RackBuilder>
implements VisitableBuilder<Rack, RackBuilder> {
    RackFluent<?> fluent;
    Boolean validationEnabled;

    public RackBuilder() {
        this(true);
    }

    public RackBuilder(Boolean validationEnabled) {
        this(new Rack(), validationEnabled);
    }

    public RackBuilder(RackFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public RackBuilder(RackFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Rack(), validationEnabled);
    }

    public RackBuilder(RackFluent<?> fluent, Rack instance) {
        this(fluent, instance, true);
    }

    public RackBuilder(RackFluent<?> fluent, Rack instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withTopologyKey(instance.getTopologyKey());
        this.validationEnabled = validationEnabled;
    }

    public RackBuilder(Rack instance) {
        this(instance, (Boolean)true);
    }

    public RackBuilder(Rack instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withTopologyKey(instance.getTopologyKey());
        this.validationEnabled = validationEnabled;
    }

    public Rack build() {
        Rack buildable = new Rack(this.fluent.getTopologyKey());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RackBuilder that = (RackBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

