/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.kafka.model.EntityUserOperatorSpec;
import io.strimzi.api.kafka.model.EntityUserOperatorSpecFluent;
import io.strimzi.api.kafka.model.ExternalLogging;
import io.strimzi.api.kafka.model.ExternalLoggingBuilder;
import io.strimzi.api.kafka.model.ExternalLoggingFluentImpl;
import io.strimzi.api.kafka.model.InlineLogging;
import io.strimzi.api.kafka.model.InlineLoggingBuilder;
import io.strimzi.api.kafka.model.InlineLoggingFluentImpl;
import io.strimzi.api.kafka.model.JvmOptions;
import io.strimzi.api.kafka.model.JvmOptionsBuilder;
import io.strimzi.api.kafka.model.JvmOptionsFluentImpl;
import io.strimzi.api.kafka.model.Logging;
import io.strimzi.api.kafka.model.Probe;
import io.strimzi.api.kafka.model.ProbeBuilder;
import io.strimzi.api.kafka.model.ProbeFluentImpl;
import java.util.Objects;

public class EntityUserOperatorSpecFluentImpl<A extends EntityUserOperatorSpecFluent<A>>
extends BaseFluent<A>
implements EntityUserOperatorSpecFluent<A> {
    private String watchedNamespace;
    private String image;
    private String secretPrefix;
    private long reconciliationIntervalSeconds;
    private Long zookeeperSessionTimeoutSeconds;
    private ProbeBuilder livenessProbe;
    private ProbeBuilder readinessProbe;
    private ResourceRequirements resources;
    private VisitableBuilder<? extends Logging, ?> logging;
    private JvmOptionsBuilder jvmOptions;

    public EntityUserOperatorSpecFluentImpl() {
    }

    public EntityUserOperatorSpecFluentImpl(EntityUserOperatorSpec instance) {
        this.withWatchedNamespace(instance.getWatchedNamespace());
        this.withImage(instance.getImage());
        this.withSecretPrefix(instance.getSecretPrefix());
        this.withReconciliationIntervalSeconds(instance.getReconciliationIntervalSeconds());
        this.withZookeeperSessionTimeoutSeconds(instance.getZookeeperSessionTimeoutSeconds());
        this.withLivenessProbe(instance.getLivenessProbe());
        this.withReadinessProbe(instance.getReadinessProbe());
        this.withResources(instance.getResources());
        this.withLogging(instance.getLogging());
        this.withJvmOptions(instance.getJvmOptions());
    }

    @Override
    public String getWatchedNamespace() {
        return this.watchedNamespace;
    }

    @Override
    public A withWatchedNamespace(String watchedNamespace) {
        this.watchedNamespace = watchedNamespace;
        return (A)this;
    }

    @Override
    public Boolean hasWatchedNamespace() {
        return this.watchedNamespace != null;
    }

    @Override
    @Deprecated
    public A withNewWatchedNamespace(String original) {
        return this.withWatchedNamespace(new String(original));
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    @Deprecated
    public A withNewImage(String original) {
        return this.withImage(new String(original));
    }

    @Override
    public String getSecretPrefix() {
        return this.secretPrefix;
    }

    @Override
    public A withSecretPrefix(String secretPrefix) {
        this.secretPrefix = secretPrefix;
        return (A)this;
    }

    @Override
    public Boolean hasSecretPrefix() {
        return this.secretPrefix != null;
    }

    @Override
    @Deprecated
    public A withNewSecretPrefix(String original) {
        return this.withSecretPrefix(new String(original));
    }

    @Override
    public long getReconciliationIntervalSeconds() {
        return this.reconciliationIntervalSeconds;
    }

    @Override
    public A withReconciliationIntervalSeconds(long reconciliationIntervalSeconds) {
        this.reconciliationIntervalSeconds = reconciliationIntervalSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasReconciliationIntervalSeconds() {
        return true;
    }

    @Override
    public Long getZookeeperSessionTimeoutSeconds() {
        return this.zookeeperSessionTimeoutSeconds;
    }

    @Override
    public A withZookeeperSessionTimeoutSeconds(Long zookeeperSessionTimeoutSeconds) {
        this.zookeeperSessionTimeoutSeconds = zookeeperSessionTimeoutSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasZookeeperSessionTimeoutSeconds() {
        return this.zookeeperSessionTimeoutSeconds != null;
    }

    @Override
    @Deprecated
    public Probe getLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    @Override
    public Probe buildLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    @Override
    public A withLivenessProbe(Probe livenessProbe) {
        this._visitables.get((Object)"livenessProbe").remove(this.livenessProbe);
        if (livenessProbe != null) {
            this.livenessProbe = new ProbeBuilder(livenessProbe);
            this._visitables.get((Object)"livenessProbe").add(this.livenessProbe);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    @Override
    public A withNewLivenessProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    @Override
    public EntityUserOperatorSpecFluent.LivenessProbeNested<A> withNewLivenessProbe() {
        return new LivenessProbeNestedImpl();
    }

    @Override
    public EntityUserOperatorSpecFluent.LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
        return new LivenessProbeNestedImpl(item);
    }

    @Override
    public EntityUserOperatorSpecFluent.LivenessProbeNested<A> editLivenessProbe() {
        return this.withNewLivenessProbeLike(this.getLivenessProbe());
    }

    @Override
    public EntityUserOperatorSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbe() {
        return this.withNewLivenessProbeLike(this.getLivenessProbe() != null ? this.getLivenessProbe() : new ProbeBuilder().build());
    }

    @Override
    public EntityUserOperatorSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
        return this.withNewLivenessProbeLike(this.getLivenessProbe() != null ? this.getLivenessProbe() : item);
    }

    @Override
    @Deprecated
    public Probe getReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    @Override
    public Probe buildReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    @Override
    public A withReadinessProbe(Probe readinessProbe) {
        this._visitables.get((Object)"readinessProbe").remove(this.readinessProbe);
        if (readinessProbe != null) {
            this.readinessProbe = new ProbeBuilder(readinessProbe);
            this._visitables.get((Object)"readinessProbe").add(this.readinessProbe);
        }
        return (A)this;
    }

    @Override
    public Boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    @Override
    public A withNewReadinessProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    @Override
    public EntityUserOperatorSpecFluent.ReadinessProbeNested<A> withNewReadinessProbe() {
        return new ReadinessProbeNestedImpl();
    }

    @Override
    public EntityUserOperatorSpecFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
        return new ReadinessProbeNestedImpl(item);
    }

    @Override
    public EntityUserOperatorSpecFluent.ReadinessProbeNested<A> editReadinessProbe() {
        return this.withNewReadinessProbeLike(this.getReadinessProbe());
    }

    @Override
    public EntityUserOperatorSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return this.withNewReadinessProbeLike(this.getReadinessProbe() != null ? this.getReadinessProbe() : new ProbeBuilder().build());
    }

    @Override
    public EntityUserOperatorSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
        return this.withNewReadinessProbeLike(this.getReadinessProbe() != null ? this.getReadinessProbe() : item);
    }

    @Override
    public ResourceRequirements getResources() {
        return this.resources;
    }

    @Override
    public A withResources(ResourceRequirements resources) {
        this.resources = resources;
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null;
    }

    @Override
    @Deprecated
    public Logging getLogging() {
        return this.logging != null ? (Logging)this.logging.build() : null;
    }

    @Override
    public Logging buildLogging() {
        return this.logging != null ? (Logging)this.logging.build() : null;
    }

    @Override
    public A withLogging(Logging logging) {
        if (logging instanceof ExternalLogging) {
            this.logging = new ExternalLoggingBuilder((ExternalLogging)logging);
            this._visitables.get((Object)"logging").add(this.logging);
        }
        if (logging instanceof InlineLogging) {
            this.logging = new InlineLoggingBuilder((InlineLogging)logging);
            this._visitables.get((Object)"logging").add(this.logging);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLogging() {
        return this.logging != null;
    }

    @Override
    public A withExternalLogging(ExternalLogging externalLogging) {
        this._visitables.get((Object)"logging").remove(this.logging);
        if (externalLogging != null) {
            this.logging = new ExternalLoggingBuilder(externalLogging);
            this._visitables.get((Object)"logging").add(this.logging);
        }
        return (A)this;
    }

    @Override
    public EntityUserOperatorSpecFluent.ExternalLoggingNested<A> withNewExternalLogging() {
        return new ExternalLoggingNestedImpl();
    }

    @Override
    public EntityUserOperatorSpecFluent.ExternalLoggingNested<A> withNewExternalLoggingLike(ExternalLogging item) {
        return new ExternalLoggingNestedImpl(item);
    }

    @Override
    public A withInlineLogging(InlineLogging inlineLogging) {
        this._visitables.get((Object)"logging").remove(this.logging);
        if (inlineLogging != null) {
            this.logging = new InlineLoggingBuilder(inlineLogging);
            this._visitables.get((Object)"logging").add(this.logging);
        }
        return (A)this;
    }

    @Override
    public EntityUserOperatorSpecFluent.InlineLoggingNested<A> withNewInlineLogging() {
        return new InlineLoggingNestedImpl();
    }

    @Override
    public EntityUserOperatorSpecFluent.InlineLoggingNested<A> withNewInlineLoggingLike(InlineLogging item) {
        return new InlineLoggingNestedImpl(item);
    }

    @Override
    @Deprecated
    public JvmOptions getJvmOptions() {
        return this.jvmOptions != null ? this.jvmOptions.build() : null;
    }

    @Override
    public JvmOptions buildJvmOptions() {
        return this.jvmOptions != null ? this.jvmOptions.build() : null;
    }

    @Override
    public A withJvmOptions(JvmOptions jvmOptions) {
        this._visitables.get((Object)"jvmOptions").remove(this.jvmOptions);
        if (jvmOptions != null) {
            this.jvmOptions = new JvmOptionsBuilder(jvmOptions);
            this._visitables.get((Object)"jvmOptions").add(this.jvmOptions);
        }
        return (A)this;
    }

    @Override
    public Boolean hasJvmOptions() {
        return this.jvmOptions != null;
    }

    @Override
    public EntityUserOperatorSpecFluent.JvmOptionsNested<A> withNewJvmOptions() {
        return new JvmOptionsNestedImpl();
    }

    @Override
    public EntityUserOperatorSpecFluent.JvmOptionsNested<A> withNewJvmOptionsLike(JvmOptions item) {
        return new JvmOptionsNestedImpl(item);
    }

    @Override
    public EntityUserOperatorSpecFluent.JvmOptionsNested<A> editJvmOptions() {
        return this.withNewJvmOptionsLike(this.getJvmOptions());
    }

    @Override
    public EntityUserOperatorSpecFluent.JvmOptionsNested<A> editOrNewJvmOptions() {
        return this.withNewJvmOptionsLike(this.getJvmOptions() != null ? this.getJvmOptions() : new JvmOptionsBuilder().build());
    }

    @Override
    public EntityUserOperatorSpecFluent.JvmOptionsNested<A> editOrNewJvmOptionsLike(JvmOptions item) {
        return this.withNewJvmOptionsLike(this.getJvmOptions() != null ? this.getJvmOptions() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityUserOperatorSpecFluentImpl that = (EntityUserOperatorSpecFluentImpl)o;
        if (this.watchedNamespace != null ? !this.watchedNamespace.equals(that.watchedNamespace) : that.watchedNamespace != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.secretPrefix != null ? !this.secretPrefix.equals(that.secretPrefix) : that.secretPrefix != null) {
            return false;
        }
        if (this.reconciliationIntervalSeconds != that.reconciliationIntervalSeconds) {
            return false;
        }
        if (this.zookeeperSessionTimeoutSeconds != null ? !this.zookeeperSessionTimeoutSeconds.equals(that.zookeeperSessionTimeoutSeconds) : that.zookeeperSessionTimeoutSeconds != null) {
            return false;
        }
        if (this.livenessProbe != null ? !this.livenessProbe.equals(that.livenessProbe) : that.livenessProbe != null) {
            return false;
        }
        if (this.readinessProbe != null ? !this.readinessProbe.equals(that.readinessProbe) : that.readinessProbe != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals((Object)that.resources) : that.resources != null) {
            return false;
        }
        if (this.logging != null ? !this.logging.equals(that.logging) : that.logging != null) {
            return false;
        }
        return !(this.jvmOptions != null ? !this.jvmOptions.equals(that.jvmOptions) : that.jvmOptions != null);
    }

    public int hashCode() {
        return Objects.hash(this.watchedNamespace, this.image, this.secretPrefix, this.reconciliationIntervalSeconds, this.zookeeperSessionTimeoutSeconds, this.livenessProbe, this.readinessProbe, this.resources, this.logging, this.jvmOptions, super.hashCode());
    }

    public class JvmOptionsNestedImpl<N>
    extends JvmOptionsFluentImpl<EntityUserOperatorSpecFluent.JvmOptionsNested<N>>
    implements EntityUserOperatorSpecFluent.JvmOptionsNested<N>,
    Nested<N> {
        private final JvmOptionsBuilder builder;

        JvmOptionsNestedImpl(JvmOptions item) {
            this.builder = new JvmOptionsBuilder(this, item);
        }

        JvmOptionsNestedImpl() {
            this.builder = new JvmOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)EntityUserOperatorSpecFluentImpl.this.withJvmOptions(this.builder.build());
        }

        @Override
        public N endJvmOptions() {
            return this.and();
        }
    }

    public class InlineLoggingNestedImpl<N>
    extends InlineLoggingFluentImpl<EntityUserOperatorSpecFluent.InlineLoggingNested<N>>
    implements EntityUserOperatorSpecFluent.InlineLoggingNested<N>,
    Nested<N> {
        private final InlineLoggingBuilder builder;

        InlineLoggingNestedImpl(InlineLogging item) {
            this.builder = new InlineLoggingBuilder(this, item);
        }

        InlineLoggingNestedImpl() {
            this.builder = new InlineLoggingBuilder(this);
        }

        @Override
        public N and() {
            return (N)EntityUserOperatorSpecFluentImpl.this.withLogging(this.builder.build());
        }

        @Override
        public N endInlineLogging() {
            return this.and();
        }
    }

    public class ExternalLoggingNestedImpl<N>
    extends ExternalLoggingFluentImpl<EntityUserOperatorSpecFluent.ExternalLoggingNested<N>>
    implements EntityUserOperatorSpecFluent.ExternalLoggingNested<N>,
    Nested<N> {
        private final ExternalLoggingBuilder builder;

        ExternalLoggingNestedImpl(ExternalLogging item) {
            this.builder = new ExternalLoggingBuilder(this, item);
        }

        ExternalLoggingNestedImpl() {
            this.builder = new ExternalLoggingBuilder(this);
        }

        @Override
        public N and() {
            return (N)EntityUserOperatorSpecFluentImpl.this.withLogging(this.builder.build());
        }

        @Override
        public N endExternalLogging() {
            return this.and();
        }
    }

    public class ReadinessProbeNestedImpl<N>
    extends ProbeFluentImpl<EntityUserOperatorSpecFluent.ReadinessProbeNested<N>>
    implements EntityUserOperatorSpecFluent.ReadinessProbeNested<N>,
    Nested<N> {
        private final ProbeBuilder builder;

        ReadinessProbeNestedImpl(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        ReadinessProbeNestedImpl() {
            this.builder = new ProbeBuilder(this);
        }

        @Override
        public N and() {
            return (N)EntityUserOperatorSpecFluentImpl.this.withReadinessProbe(this.builder.build());
        }

        @Override
        public N endReadinessProbe() {
            return this.and();
        }
    }

    public class LivenessProbeNestedImpl<N>
    extends ProbeFluentImpl<EntityUserOperatorSpecFluent.LivenessProbeNested<N>>
    implements EntityUserOperatorSpecFluent.LivenessProbeNested<N>,
    Nested<N> {
        private final ProbeBuilder builder;

        LivenessProbeNestedImpl(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        LivenessProbeNestedImpl() {
            this.builder = new ProbeBuilder(this);
        }

        @Override
        public N and() {
            return (N)EntityUserOperatorSpecFluentImpl.this.withLivenessProbe(this.builder.build());
        }

        @Override
        public N endLivenessProbe() {
            return this.and();
        }
    }
}

