/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.Spec;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.Minimum;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"pause", "tasksMax", "config"})
public abstract class AbstractConnectorSpec
extends Spec {
    private static final long serialVersionUID = 1L;
    private static final String FORBIDDEN_PARAMETERS = "connector.class, tasks.max";
    private Integer tasksMax;
    private Boolean pause;
    private Map<String, Object> config = new HashMap<String, Object>(0);

    @Description(value="The maximum number of tasks for the Kafka Connector")
    @Minimum(value=1)
    public Integer getTasksMax() {
        return this.tasksMax;
    }

    public void setTasksMax(Integer tasksMax) {
        this.tasksMax = tasksMax;
    }

    @Description(value="The Kafka Connector configuration. The following properties cannot be set: connector.class, tasks.max")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, Object> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, Object> config) {
        this.config = config;
    }

    @Description(value="Whether the connector should be paused. Defaults to false.")
    public Boolean getPause() {
        return this.pause;
    }

    public void setPause(Boolean pause) {
        this.pause = pause;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractConnectorSpec)) {
            return false;
        }
        AbstractConnectorSpec other = (AbstractConnectorSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$tasksMax = this.getTasksMax();
        Integer other$tasksMax = other.getTasksMax();
        if (this$tasksMax == null ? other$tasksMax != null : !((Object)this$tasksMax).equals(other$tasksMax)) {
            return false;
        }
        Boolean this$pause = this.getPause();
        Boolean other$pause = other.getPause();
        if (this$pause == null ? other$pause != null : !((Object)this$pause).equals(other$pause)) {
            return false;
        }
        Map<String, Object> this$config = this.getConfig();
        Map<String, Object> other$config = other.getConfig();
        return !(this$config == null ? other$config != null : !((Object)this$config).equals(other$config));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AbstractConnectorSpec;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $tasksMax = this.getTasksMax();
        result = result * 59 + ($tasksMax == null ? 43 : ((Object)$tasksMax).hashCode());
        Boolean $pause = this.getPause();
        result = result * 59 + ($pause == null ? 43 : ((Object)$pause).hashCode());
        Map<String, Object> $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        return result;
    }
}

