/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import io.swagger.models.Contact;
import io.swagger.models.Info;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.parameters.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Documentation;
import springfox.documentation.service.Operation;
import springfox.documentation.service.ResourceListing;
import springfox.documentation.swagger2.mappers.LicenseMapper;
import springfox.documentation.swagger2.mappers.ModelMapper;
import springfox.documentation.swagger2.mappers.ParameterMapper;
import springfox.documentation.swagger2.mappers.SecurityMapper;
import springfox.documentation.swagger2.mappers.ServiceModelToSwagger2Mapper;
import springfox.documentation.swagger2.mappers.VendorExtensionsMapper;

@Component
public class ServiceModelToSwagger2MapperImpl
extends ServiceModelToSwagger2Mapper {
    @Autowired
    private ModelMapper modelMapper;
    @Autowired
    private ParameterMapper parameterMapper;
    @Autowired
    private SecurityMapper securityMapper;
    @Autowired
    private LicenseMapper licenseMapper;
    @Autowired
    private VendorExtensionsMapper vendorExtensionsMapper;

    @Override
    public Swagger mapDocumentation(Documentation from) {
        List list3;
        if (from == null) {
            return null;
        }
        Swagger swagger = new Swagger();
        swagger.setVendorExtensions(this.vendorExtensionsMapper.mapExtensions(from.getVendorExtensions()));
        swagger.setSchemes(this.mapSchemes(from.getSchemes()));
        swagger.setPaths(this.mapApiListings(from.getApiListings()));
        swagger.setHost(from.getHost());
        swagger.setDefinitions(this.modelMapper.modelsFromApiListings(from.getApiListings()));
        swagger.setSecurityDefinitions(this.securityMapper.toSecuritySchemeDefinitions(from.getResourceListing()));
        swagger.setInfo(this.mapApiInfo(this.fromResourceListingInfo(from)));
        swagger.setBasePath(from.getBasePath());
        swagger.setTags(this.tagSetToTagList(from.getTags()));
        List list2 = from.getConsumes();
        if (list2 != null) {
            swagger.setConsumes(new ArrayList(list2));
        }
        if ((list3 = from.getProduces()) != null) {
            swagger.setProduces(new ArrayList(list3));
        }
        return swagger;
    }

    @Override
    protected Info mapApiInfo(ApiInfo from) {
        if (from == null) {
            return null;
        }
        Info info = new Info();
        info.setLicense(this.licenseMapper.apiInfoToLicense(from));
        info.setVendorExtensions(this.vendorExtensionsMapper.mapExtensions(from.getVendorExtensions()));
        info.setTermsOfService(from.getTermsOfServiceUrl());
        info.setContact(this.map(from.getContact()));
        info.setVersion(from.getVersion());
        info.setTitle(from.getTitle());
        info.setDescription(from.getDescription());
        return info;
    }

    @Override
    protected Contact map(springfox.documentation.service.Contact from) {
        if (from == null) {
            return null;
        }
        Contact contact = new Contact();
        contact.setName(from.getName());
        contact.setUrl(from.getUrl());
        contact.setEmail(from.getEmail());
        return contact;
    }

    @Override
    protected io.swagger.models.Operation mapOperation(Operation from) {
        Set set2;
        Set set1;
        if (from == null) {
            return null;
        }
        io.swagger.models.Operation operation = new io.swagger.models.Operation();
        operation.setSecurity(this.mapAuthorizations(from.getSecurityReferences()));
        operation.vendorExtensions(this.vendorExtensionsMapper.mapExtensions(from.getVendorExtensions()));
        operation.setDescription(from.getNotes());
        operation.setOperationId(from.getUniqueId());
        operation.setResponses(this.mapResponseMessages(from.getResponseMessages()));
        operation.setSchemes(this.stringSetToSchemeList(from.getProtocol()));
        operation.setSummary(from.getSummary());
        Set set = from.getConsumes();
        if (set != null) {
            operation.setConsumes(new ArrayList(set));
        }
        if ((set1 = from.getProduces()) != null) {
            operation.setProduces(new ArrayList(set1));
        }
        if ((set2 = from.getTags()) != null) {
            operation.setTags(new ArrayList(set2));
        }
        if (from.getDeprecated() != null) {
            operation.setDeprecated(Boolean.valueOf(Boolean.parseBoolean(from.getDeprecated())));
        }
        operation.setParameters(this.parameterListToParameterList(from.getParameters()));
        return operation;
    }

    @Override
    protected Tag mapTag(springfox.documentation.service.Tag from) {
        if (from == null) {
            return null;
        }
        Tag tag = new Tag();
        tag.setVendorExtensions(this.vendorExtensionsMapper.mapExtensions(from.getVendorExtensions()));
        tag.setName(from.getName());
        tag.setDescription(from.getDescription());
        return tag;
    }

    private ApiInfo fromResourceListingInfo(Documentation documentation) {
        if (documentation == null) {
            return null;
        }
        ResourceListing resourceListing = documentation.getResourceListing();
        if (resourceListing == null) {
            return null;
        }
        ApiInfo info = resourceListing.getInfo();
        if (info == null) {
            return null;
        }
        return info;
    }

    protected List<Tag> tagSetToTagList(Set<springfox.documentation.service.Tag> set) {
        if (set == null) {
            return null;
        }
        ArrayList<Tag> list = new ArrayList<Tag>(set.size());
        for (springfox.documentation.service.Tag tag : set) {
            list.add(this.mapTag(tag));
        }
        return list;
    }

    protected List<Scheme> stringSetToSchemeList(Set<String> set) {
        if (set == null) {
            return null;
        }
        ArrayList<Scheme> list = new ArrayList<Scheme>(set.size());
        for (String string : set) {
            list.add(Enum.valueOf(Scheme.class, string));
        }
        return list;
    }

    protected List<Parameter> parameterListToParameterList(List<springfox.documentation.service.Parameter> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Parameter> list1 = new ArrayList<Parameter>(list.size());
        for (springfox.documentation.service.Parameter parameter : list) {
            list1.add(this.parameterMapper.mapParameter(parameter));
        }
        return list1;
    }
}

