/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.service.Parameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.swagger.common.SwaggerPluginSupport;
import springfox.documentation.swagger.readers.operation.OperationImplicitParameterReader;

@Component
@Order(value=-2147482648)
public class OperationImplicitParametersReader
implements OperationBuilderPlugin {
    public void apply(OperationContext context) {
        context.operationBuilder().parameters(this.readParameters(context));
    }

    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }

    protected List<Parameter> readParameters(OperationContext context) {
        Optional annotation = context.findAnnotation(ApiImplicitParams.class);
        ArrayList parameters = Lists.newArrayList();
        if (annotation.isPresent()) {
            for (ApiImplicitParam param : ((ApiImplicitParams)annotation.get()).value()) {
                parameters.add(OperationImplicitParameterReader.implicitParameter(param));
            }
        }
        return parameters;
    }
}

