/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.operation;

import com.fasterxml.classmate.ResolvedType;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ResponseStatus;
import springfox.documentation.builders.ResponseMessageBuilder;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.schema.Types;
import springfox.documentation.schema.plugins.SchemaPluginsManager;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.EnumTypeDeterminer;
import springfox.documentation.spi.schema.ViewProviderPlugin;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;

@Component
@Order(value=-2147483648)
public class ResponseMessagesReader
implements OperationBuilderPlugin {
    private final EnumTypeDeterminer enumTypeDeterminer;
    private final TypeNameExtractor typeNameExtractor;
    private final SchemaPluginsManager pluginsManager;

    @Autowired
    public ResponseMessagesReader(EnumTypeDeterminer enumTypeDeterminer, TypeNameExtractor typeNameExtractor, SchemaPluginsManager pluginsManager) {
        this.enumTypeDeterminer = enumTypeDeterminer;
        this.typeNameExtractor = typeNameExtractor;
        this.pluginsManager = pluginsManager;
    }

    public void apply(OperationContext context) {
        List responseMessages = context.getGlobalResponseMessages(context.httpMethod().toString());
        context.operationBuilder().responseMessages(new HashSet(responseMessages));
        this.applyReturnTypeOverride(context);
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    private void applyReturnTypeOverride(OperationContext context) {
        ResolvedType returnType = context.alternateFor(context.getReturnType());
        int httpStatusCode = ResponseMessagesReader.httpStatusCode(context);
        String message = ResponseMessagesReader.message(context);
        ModelReference modelRef = null;
        ViewProviderPlugin viewProvider = this.pluginsManager.viewProvider(context.getDocumentationContext().getDocumentationType());
        if (!Types.isVoid((ResolvedType)returnType)) {
            ModelContext modelContext = context.operationModelsBuilder().addReturn(returnType, viewProvider.viewFor(returnType, context));
            HashMap knownNames = new HashMap();
            ((Set)Optional.ofNullable(context.getKnownModels().get(modelContext.getParameterId())).orElse(new HashSet())).forEach(model -> knownNames.put(model.getId(), model.getName()));
            modelRef = (ModelReference)ResolvedTypes.modelRefFactory((ModelContext)modelContext, (EnumTypeDeterminer)this.enumTypeDeterminer, (TypeNameExtractor)this.typeNameExtractor, knownNames).apply(returnType);
        }
        ResponseMessage built = new ResponseMessageBuilder().code(httpStatusCode).message(message).responseModel(modelRef).build();
        context.operationBuilder().responseMessages(Collections.singleton(built));
    }

    public static int httpStatusCode(OperationContext context) {
        Optional responseStatus = context.findAnnotation(ResponseStatus.class);
        int httpStatusCode = HttpStatus.OK.value();
        if (responseStatus.isPresent()) {
            httpStatusCode = ((ResponseStatus)responseStatus.get()).value().value();
        }
        return httpStatusCode;
    }

    public static String message(OperationContext context) {
        Optional responseStatus = context.findAnnotation(ResponseStatus.class);
        String reasonPhrase = HttpStatus.OK.getReasonPhrase();
        if (responseStatus.isPresent() && (reasonPhrase = ((ResponseStatus)responseStatus.get()).reason()).isEmpty()) {
            reasonPhrase = ((ResponseStatus)responseStatus.get()).value().getReasonPhrase();
        }
        return reasonPhrase;
    }
}

