/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web;

import java.util.Objects;
import java.util.function.BiPredicate;
import springfox.documentation.spi.service.contexts.RequestMappingContext;

public class OperationCachingEquivalence
implements BiPredicate<RequestMappingContext, RequestMappingContext> {
    @Override
    public boolean test(RequestMappingContext first, RequestMappingContext second) {
        if (this.bothAreNull(first, second)) {
            return true;
        }
        if (this.eitherOfThemIsNull(first, second)) {
            return false;
        }
        return Objects.equals(first.key(), second.key()) && Objects.equals(first.getGenericsNamingStrategy(), second.getGenericsNamingStrategy());
    }

    private boolean eitherOfThemIsNull(RequestMappingContext first, RequestMappingContext second) {
        return first.key() == null || second.key() == null;
    }

    private boolean bothAreNull(RequestMappingContext first, RequestMappingContext second) {
        return first.key() == null && second.key() == null;
    }

    public Wrapper wrap(RequestMappingContext outerContext) {
        return new Wrapper(outerContext, this);
    }

    public int doHash(RequestMappingContext requestMappingContext) {
        return Objects.hash(requestMappingContext.key(), requestMappingContext.getRequestMappingPattern(), requestMappingContext.getGenericsNamingStrategy());
    }

    public static class Wrapper {
        private final RequestMappingContext requestMappingContext;
        private final OperationCachingEquivalence equivalence;

        public Wrapper(RequestMappingContext requestMappingContext, OperationCachingEquivalence equivalence) {
            this.requestMappingContext = requestMappingContext;
            this.equivalence = equivalence;
        }

        public boolean equals(Object other) {
            return this.equivalence.equals(((Wrapper)other).equivalence) && this.equivalence.test(this.requestMappingContext, ((Wrapper)other).requestMappingContext);
        }

        public int hashCode() {
            return this.equivalence.doHash(this.requestMappingContext);
        }

        public RequestMappingContext get() {
            return this.requestMappingContext;
        }
    }
}

