/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import com.fasterxml.classmate.TypeResolver;
import java.lang.reflect.Type;
import javax.xml.bind.annotation.XmlType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.Xml;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.ModelBuilderPlugin;
import springfox.documentation.spi.schema.contexts.ModelContext;

@Component
public class XmlModelPlugin
implements ModelBuilderPlugin {
    private final TypeResolver typeResolver;

    @Autowired
    public XmlModelPlugin(TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    public void apply(ModelContext context) {
        XmlType annotation = (XmlType)AnnotationUtils.findAnnotation(this.forClass(context), XmlType.class);
        if (annotation != null) {
            context.getBuilder().xml(this.buildXml(annotation));
        }
    }

    private Xml buildXml(XmlType annotation) {
        return new Xml().name(this.defaultToNull(annotation.name())).attribute(Boolean.valueOf(false)).namespace(this.defaultToNull(annotation.namespace())).wrapped(Boolean.valueOf(false));
    }

    private String defaultToNull(String value) {
        return "##default".equalsIgnoreCase(value) ? null : value;
    }

    private Class<?> forClass(ModelContext context) {
        return this.typeResolver.resolve(context.getType(), new Type[0]).getErasedType();
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }
}

